/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.query.parser.sparql;

import com.complexible.common.rdf.query.parser.sparql.AbstractASTVisitor;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTBlankNode;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTBlankNodePropertyList;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTCollection;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTOperationContainer;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTScope;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTVar;
import com.complexible.common.rdf.query.parser.sparql.ast.VisitorException;
import com.stardog.stark.query.MalformedQuery;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BlankNodeVarProcessor
extends AbstractASTVisitor {
    public static Set<String> process(ASTOperationContainer qc) throws MalformedQuery {
        try {
            BlankNodeToVarConverter converter = new BlankNodeToVarConverter();
            qc.jjtAccept(converter, null);
            return converter.getUsedBNodeIDs();
        }
        catch (VisitorException e) {
            throw new MalformedQuery((Throwable)e);
        }
    }

    private static class BlankNodeToVarConverter
    extends AbstractASTVisitor {
        private int anonVarNo = 1;
        private Map<String, String> conversionMap = new HashMap<String, String>();
        private Set<String> usedBNodeIDs = new HashSet<String>();

        private BlankNodeToVarConverter() {
        }

        private String createAnonVarName() {
            return "_anon_" + this.anonVarNo++;
        }

        public Set<String> getUsedBNodeIDs() {
            this.usedBNodeIDs.addAll(this.conversionMap.keySet());
            return Collections.unmodifiableSet(this.usedBNodeIDs);
        }

        @Override
        public Object visit(ASTScope node, Object data) throws VisitorException {
            this.usedBNodeIDs.addAll(this.conversionMap.keySet());
            this.conversionMap.clear();
            return super.visit(node, data);
        }

        @Override
        public Object visit(ASTBlankNode node, Object data) throws VisitorException {
            String bnodeID = node.getID();
            String varName = this.findVarName(bnodeID);
            if (varName == null) {
                varName = this.createAnonVarName();
                if (bnodeID != null) {
                    this.conversionMap.put(bnodeID, varName);
                }
            }
            ASTVar varNode = new ASTVar(72);
            varNode.setName(varName);
            varNode.setAnonymous(true);
            node.jjtReplaceWith(varNode);
            return super.visit(node, data);
        }

        private String findVarName(String bnodeID) throws VisitorException {
            if (bnodeID == null) {
                return null;
            }
            String varName = this.conversionMap.get(bnodeID);
            if (varName == null && this.usedBNodeIDs.contains(bnodeID)) {
                throw new VisitorException("BNodeID already used in another scope: " + bnodeID);
            }
            return varName;
        }

        @Override
        public Object visit(ASTBlankNodePropertyList node, Object data) throws VisitorException {
            node.setVarName(this.createAnonVarName());
            return super.visit(node, data);
        }

        @Override
        public Object visit(ASTCollection node, Object data) throws VisitorException {
            node.setVarName(this.createAnonVarName());
            return super.visit(node, data);
        }
    }
}

