/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.query.parser.sparql;

import com.complexible.common.rdf.query.parser.sparql.AbstractASTVisitor;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTBaseDecl;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTIRI;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTIRIFunc;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTOperationContainer;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTServiceGraphPattern;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTUnparsedQuadDataBlock;
import com.complexible.common.rdf.query.parser.sparql.ast.VisitorException;
import com.stardog.stark.query.MalformedQuery;
import com.stardog.stark.util.ParsedURI;

public class BaseDeclProcessor {
    public static void process(ASTOperationContainer qc, String externalBaseURI) throws MalformedQuery {
        ParsedURI parsedBaseURI = null;
        ASTBaseDecl baseDecl = qc.getBaseDecl();
        if (baseDecl != null) {
            parsedBaseURI = new ParsedURI(baseDecl.getIRI());
            if (!parsedBaseURI.isAbsolute()) {
                throw new MalformedQuery("BASE IRI is not an absolute IRI: " + externalBaseURI);
            }
        } else if (externalBaseURI != null && !(parsedBaseURI = new ParsedURI(externalBaseURI)).isAbsolute()) {
            throw new IllegalArgumentException("Supplied base URI is not an absolute IRI: " + externalBaseURI);
        }
        if (parsedBaseURI != null) {
            RelativeIRIResolver visitor = new RelativeIRIResolver(parsedBaseURI);
            try {
                qc.jjtAccept(visitor, null);
            }
            catch (VisitorException e) {
                throw new MalformedQuery((Throwable)e);
            }
        }
    }

    private static class RelativeIRIResolver
    extends AbstractASTVisitor {
        private ParsedURI parsedBaseURI;

        public RelativeIRIResolver(ParsedURI parsedBaseURI) {
            this.parsedBaseURI = parsedBaseURI;
        }

        @Override
        public Object visit(ASTIRI node, Object data) throws VisitorException {
            ParsedURI resolvedURI = this.parsedBaseURI.resolve(node.getValue());
            node.setValue(resolvedURI.toString());
            return super.visit(node, data);
        }

        @Override
        public Object visit(ASTIRIFunc node, Object data) throws VisitorException {
            node.setBaseURI(this.parsedBaseURI.toString());
            return super.visit(node, data);
        }

        @Override
        public Object visit(ASTServiceGraphPattern node, Object data) throws VisitorException {
            node.setBaseURI(this.parsedBaseURI.toString());
            return super.visit(node, data);
        }

        @Override
        public Object visit(ASTUnparsedQuadDataBlock node, Object data) {
            String baseURIDeclaration = "BASE <" + String.valueOf(this.parsedBaseURI) + "> \n";
            node.setDataBlock(baseURIDeclaration + node.getDataBlock());
            return super.visit(node, data);
        }
    }
}

