/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.query;

import com.complexible.common.rdf.query.Edge;
import com.complexible.common.rdf.query.ImmutableEdge;
import com.complexible.common.rdf.query.ImmutablePath;
import com.complexible.common.rdf.query.Path;
import com.complexible.common.rdf.query.PathQueryResult;
import com.google.common.collect.Lists;
import com.stardog.stark.query.BindingSet;
import com.stardog.stark.query.BindingSets;
import com.stardog.stark.query.QueryExecutionFailure;
import com.stardog.stark.query.SelectQueryResult;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class TuplesAsPathQueryResult
implements PathQueryResult {
    private static final BindingSet NO_BINDINGS = BindingSets.empty();
    private final SelectQueryResult mTuples;
    private final String mStartVar;
    private final String mEndVar;
    private final List<String> mStartBindingNames = Lists.newArrayList();
    private final List<String> mEndBindingNames;
    private final List<String> mEdgeBindingNames = Lists.newArrayList();
    private Path mNextPath;

    public TuplesAsPathQueryResult(SelectQueryResult theTuples) {
        this.mEndBindingNames = Lists.newArrayList();
        String aStartVar = null;
        String aEndVar = null;
        String aPrev = null;
        List<String> aVars = this.mStartBindingNames;
        for (String aVar : theTuples.variables()) {
            if (aPrev != null && aVar.equals(aPrev)) {
                if (aVars == this.mStartBindingNames) {
                    aStartVar = aVar;
                    aVars = this.mEdgeBindingNames;
                } else {
                    aEndVar = aVar;
                    aVars = this.mEndBindingNames;
                }
            }
            aVars.add(aVar);
            aPrev = aVar;
        }
        this.mStartVar = aStartVar;
        this.mEndVar = aEndVar;
        this.mTuples = theTuples;
        this.mStartBindingNames.remove(this.mStartBindingNames.size() - 1);
        this.mStartBindingNames.add(0, this.mStartVar);
        assert (this.mStartVar != null);
        assert (this.mEndVar != null);
    }

    @Override
    public List<String> getPathStartVariableNames() {
        return this.mStartBindingNames;
    }

    @Override
    public List<String> getPathEndVariableNames() {
        return this.mEndBindingNames;
    }

    @Override
    public List<String> getEdgeVariableNames() {
        return this.mEdgeBindingNames;
    }

    public void close() throws QueryExecutionFailure {
        this.mTuples.close();
    }

    public boolean hasNext() throws QueryExecutionFailure {
        if (this.mNextPath != null) {
            return true;
        }
        if (!this.mTuples.hasNext()) {
            return false;
        }
        this.readPath();
        return this.mNextPath != null;
    }

    private void readPath() {
        BindingSet aTuple;
        ArrayList aPath = Lists.newArrayList();
        BindingSet aStartBindings = NO_BINDINGS;
        BindingSet aEndBindings = NO_BINDINGS;
        while (this.mTuples.hasNext() && (aTuple = (BindingSet)this.mTuples.next()).size() != 0) {
            if (aTuple.binds(this.mStartVar) && aTuple.binds(this.mEndVar)) {
                aPath.add(this.asEdge(aTuple));
                continue;
            }
            if (aPath.isEmpty()) {
                aStartBindings = aTuple;
                continue;
            }
            aEndBindings = aTuple;
        }
        this.mNextPath = new ImmutablePath(aPath, aStartBindings, aEndBindings);
    }

    private Edge asEdge(BindingSet theEdgeTuple) {
        return new ImmutableEdge(this.mStartVar, this.mEndVar, theEdgeTuple);
    }

    public Path next() throws QueryExecutionFailure {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Path aNext = this.mNextPath;
        this.mNextPath = null;
        return aNext;
    }

    public void remove() throws QueryExecutionFailure {
        throw new UnsupportedOperationException("This query result set is immutable");
    }
}

