/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.query;

import com.complexible.common.rdf.query.parser.sparql.ast.ASTPrefixDecl;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTUpdateContainer;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTUpdateSequence;
import com.complexible.common.rdf.query.parser.sparql.ast.SyntaxTreeBuilder;
import com.complexible.common.rdf.rio.TurtleValueWriter;
import com.stardog.stark.IRI;
import com.stardog.stark.Namespace;
import com.stardog.stark.Namespaces;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.StatementPattern;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.query.Dataset;
import com.stardog.stark.query.Datasets;
import com.stardog.stark.query.sparql.SPARQL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public final class SPARQLUtil {
    private static final String EOL = System.getProperty("line.separator");
    public static final String PLAN_HEADER = "QueryPlan";
    public static final long NO_LIMIT = -1L;
    public static final long NO_OFFSET = -1L;
    private static final Pattern prefix_pattern = Pattern.compile("prefix[^:]+:\\s*<[^>]*>\\s*", 2);
    private static final Pattern base_comment = Pattern.compile("^((base\\s+<[^>]*>\\s*)|([\t ]*#([^\n\r]*)))([\r|\r\n|\n])", 10);

    private SPARQLUtil() {
        throw new AssertionError();
    }

    public static QueryType getType(String theQuery) {
        String aStrippedQuery = SPARQLUtil.removeSPARQLQueryProlog(theQuery).toUpperCase();
        if (aStrippedQuery.startsWith("SELECT")) {
            return QueryType.SELECT;
        }
        if (aStrippedQuery.startsWith("CONSTRUCT") || aStrippedQuery.startsWith("DESCRIBE") || aStrippedQuery.startsWith("VALIDATE")) {
            return QueryType.GRAPH;
        }
        if (aStrippedQuery.startsWith("ASK")) {
            return QueryType.ASK;
        }
        if (aStrippedQuery.startsWith("PATHS")) {
            return QueryType.PATH;
        }
        if (aStrippedQuery.startsWith("SHORTEST PATHS")) {
            return QueryType.PATH;
        }
        if (aStrippedQuery.startsWith("ALL PATHS")) {
            return QueryType.PATH;
        }
        if (aStrippedQuery.startsWith(PLAN_HEADER.toUpperCase())) {
            return QueryType.PLAN;
        }
        return QueryType.UPDATE;
    }

    public static boolean isWriteOnlyUpdate(String theQuery) {
        String aStrippedQuery = SPARQLUtil.removeSPARQLQueryProlog(theQuery).toUpperCase().trim();
        return SPARQLUtil.containsWithOptionalSpaces(aStrippedQuery, "INSERT", "DATA") || SPARQLUtil.containsWithOptionalSpaces(aStrippedQuery, "DELETE", "DATA") || aStrippedQuery.startsWith("LOAD") || aStrippedQuery.startsWith("CLEAR") || aStrippedQuery.startsWith("DROP") || aStrippedQuery.startsWith("CREATE") || aStrippedQuery.startsWith("COPY") || aStrippedQuery.startsWith("MOVE") || aStrippedQuery.startsWith("ADD");
    }

    static boolean containsWithOptionalSpaces(String theStr, String theFirst, String theSecond) {
        int aStart = theStr.indexOf(theFirst);
        if (aStart < 0) {
            return false;
        }
        String aTrimmed = theStr.substring(aStart + theFirst.length()).trim();
        return aTrimmed.startsWith(theSecond);
    }

    @Nonnull
    public static String toQuery(@Nonnull String theQuery, String reasoningSchema, long theOffset, long theLimit, @Nonnull Map<String, Value> theBindings, @Nonnull Dataset theDataset) {
        boolean hasDataset;
        boolean hasReasoning = reasoningSchema != null;
        boolean hasOffset = theOffset != -1L;
        boolean hasLimit = theLimit != -1L;
        boolean hasBindings = !theBindings.isEmpty();
        boolean bl = hasDataset = theDataset != Datasets.NO_DATASET;
        if (hasReasoning || hasOffset || hasLimit || hasBindings || hasDataset) {
            StringBuilder aBuilder = new StringBuilder(theQuery);
            aBuilder.append(EOL).append("# Overrides by the API: ");
            if (hasReasoning) {
                aBuilder.append(EOL).append("# REASONING SCHEMA ").append(reasoningSchema);
            }
            if (hasOffset) {
                aBuilder.append(EOL).append("# OFFSET ").append(theOffset);
            }
            if (hasLimit) {
                aBuilder.append(EOL).append("# LIMIT ").append(theLimit);
            }
            if (hasBindings) {
                TurtleValueWriter aWriter = new TurtleValueWriter((Iterable<Namespace>)Namespaces.DEFAULT);
                aBuilder.append(EOL).append("# PARAMETERS ( ");
                for (String aVar : theBindings.keySet()) {
                    aBuilder.append('?').append(aVar).append(' ');
                }
                aBuilder.append(") {").append(EOL);
                for (Value aValue : theBindings.values()) {
                    aBuilder.append("# ").append(aWriter.write(aValue)).append(EOL);
                }
                aBuilder.append("# }");
            }
            if (hasDataset) {
                for (Resource uri : theDataset.defaultGraphs()) {
                    aBuilder.append(EOL).append("# FROM <").append(uri).append(">");
                }
                for (Resource uri : theDataset.namedGraphs()) {
                    aBuilder.append(EOL).append("# FROM NAMED <").append(uri).append(">");
                }
                for (Resource uri : theDataset.excludedGraphs()) {
                    aBuilder.append(EOL).append("# EXCLUDE <").append(uri).append(">");
                }
                for (Resource uri : theDataset.defaultRemoveGraphs()) {
                    aBuilder.append(EOL).append("# DELETE FROM <").append(uri).append(">");
                }
                if (theDataset.defaultInsertGraph().isPresent()) {
                    aBuilder.append(EOL).append("# INSERT INTO <").append(theDataset.defaultInsertGraph().get()).append(">");
                }
            }
            return aBuilder.toString();
        }
        return theQuery;
    }

    public static String removeSPARQLQueryProlog(String theQuery) {
        if (theQuery.length() == 0) {
            throw new IllegalArgumentException("Query string cannot be empty");
        }
        char ch = Character.toLowerCase(theQuery.charAt(0));
        if (ch == 's' || ch == 'c' || ch == 'd') {
            return theQuery;
        }
        String queryString = theQuery;
        StringBuilder aQuery = new StringBuilder();
        Matcher matcher = base_comment.matcher(queryString);
        int aIndex = 0;
        while (matcher.find()) {
            aQuery.append(queryString.substring(aIndex, matcher.start()));
            aIndex = matcher.end();
        }
        aQuery.append(queryString.substring(aIndex, queryString.length()));
        queryString = aQuery.toString().trim();
        aQuery.delete(0, aQuery.length());
        aIndex = 0;
        matcher = prefix_pattern.matcher(queryString);
        while (matcher.find()) {
            aQuery.append(queryString.substring(aIndex, matcher.start()));
            aIndex = matcher.end();
        }
        aQuery.append(queryString.substring(aIndex, queryString.length()));
        return aQuery.toString();
    }

    public static Iterable<Namespace> getNamespaces(final String theQuery) {
        return new Iterable<Namespace>(){

            @Override
            public Iterator<Namespace> iterator() {
                try {
                    QueryType aType = SPARQLUtil.getType(theQuery);
                    List<ASTPrefixDecl> aNamespaces = null;
                    if (aType == QueryType.UPDATE) {
                        ASTUpdateSequence updateSequence = SyntaxTreeBuilder.parseUpdateSequence(theQuery);
                        List<ASTUpdateContainer> updateOperations = updateSequence.getUpdateContainers();
                        for (int i = 0; aNamespaces == null && i < updateOperations.size(); ++i) {
                            ASTUpdateContainer uc = updateOperations.get(i);
                            aNamespaces = uc.getPrefixDeclList();
                        }
                    } else {
                        aNamespaces = SyntaxTreeBuilder.parseQuery(theQuery).getPrefixDeclList();
                    }
                    return aNamespaces.stream().map(thePrefixDecl -> Values.namespace((String)thePrefixDecl.getPrefix(), (String)thePrefixDecl.getIRI().getValue())).iterator();
                }
                catch (Throwable t) {
                    return Namespaces.DEFAULT.iterator();
                }
            }
        };
    }

    public static String buildRemoveQuery(Statement theStmtPattern) {
        Resource aContext = theStmtPattern.context();
        StringBuffer aQueryBuffer = new StringBuffer("delete {\n");
        if (aContext != StatementPattern.WILDCARD && aContext != Values.DEFAULT_GRAPH) {
            SPARQLUtil.appendGraph(aQueryBuffer, theStmtPattern);
        } else {
            SPARQLUtil.appendSPO(aQueryBuffer, theStmtPattern);
        }
        aQueryBuffer.append(" }\n");
        SPARQLUtil.appendWhereClause(aQueryBuffer, theStmtPattern);
        return aQueryBuffer.toString();
    }

    private static StringBuffer appendWhereClause(StringBuffer theQueryBuffer, Statement theStmtPattern) {
        Resource aContext = theStmtPattern.context();
        if (aContext != StatementPattern.WILDCARD && aContext != Values.DEFAULT_GRAPH) {
            theQueryBuffer.append("using named ").append(SPARQL.toQueryString((Value)aContext)).append("\n");
            theQueryBuffer.append("where {\n");
            SPARQLUtil.appendGraph(theQueryBuffer, theStmtPattern);
            theQueryBuffer.append("}\n");
        } else {
            theQueryBuffer.append("where {\n");
            SPARQLUtil.appendSPO(theQueryBuffer, theStmtPattern);
            theQueryBuffer.append("}\n");
        }
        return theQueryBuffer;
    }

    private static StringBuffer appendGraph(StringBuffer theQueryBuffer, Statement theStmtPattern) {
        theQueryBuffer.append("graph ?g {\n");
        SPARQLUtil.appendSPO(theQueryBuffer, theStmtPattern);
        return theQueryBuffer.append("}\n");
    }

    private static StringBuffer appendSPO(StringBuffer theQueryBuffer, Statement theStmtPattern) {
        Resource aSubject = theStmtPattern.subject();
        IRI aPredicate = theStmtPattern.predicate();
        Value aObject = theStmtPattern.object();
        String aBGP = String.format(" %s %s %s . \n", aSubject != StatementPattern.WILDCARD ? SPARQL.toQueryString((Value)aSubject) : "?s", aPredicate != StatementPattern.WILDCARD ? SPARQL.toQueryString((Value)aPredicate) : "?p", aObject != StatementPattern.WILDCARD ? SPARQL.toQueryString((Value)aObject) : "?o");
        return theQueryBuffer.append(aBGP);
    }

    public static enum QueryType {
        SELECT,
        GRAPH,
        ASK,
        UPDATE,
        DESCRIBE,
        VALIDATE,
        PATH,
        PLAN;

    }
}

