/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.query;

import com.brsanthu.dataexporter.model.CellDetails;
import com.complexible.common.dataexporter.WordWrapStringColumn;
import com.complexible.common.rdf.rio.TurtleValueWriter;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;

public class RDFValueColumn
extends WordWrapStringColumn {
    private final TurtleValueWriter mValueWriter;

    public RDFValueColumn(String name, TurtleValueWriter theValueWriter) {
        super(name);
        this.mValueWriter = theValueWriter;
    }

    public String format(CellDetails cellDetails) {
        return this.format(cellDetails.getCellValue());
    }

    public String format(Object value) {
        if (value instanceof Literal) {
            return this.mValueWriter.write((Value)((Literal)value));
        }
        if (value instanceof IRI) {
            String str = this.mValueWriter.write((Value)((IRI)value));
            if (str.charAt(0) == '<') {
                return str.substring(1, str.length() - 1);
            }
            return str;
        }
        if (value instanceof Statement) {
            Statement stmt = (Statement)value;
            Object str = String.format("{ %s %s %s }", this.format(stmt.subject()), this.format(stmt.predicate()), this.format(stmt.object()));
            if (!Values.isDefaultGraph((Resource)stmt.context())) {
                str = this.format(stmt.context()) + " " + (String)str;
            }
            return str;
        }
        return value.toString();
    }
}

