/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.query;

import com.complexible.common.rdf.query.Edge;
import com.complexible.common.rdf.query.Path;
import com.complexible.common.rdf.query.PathQueryResult;
import com.google.common.collect.Lists;
import com.stardog.stark.query.BindingSet;
import com.stardog.stark.query.BindingSets;
import com.stardog.stark.query.QueryExecutionFailure;
import com.stardog.stark.query.SelectQueryResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;

public class PathsAsTupleQueryResult
implements SelectQueryResult {
    private final PathQueryResult mPaths;
    private final List<String> mVarNames;
    private BindingSet mNextTuple;
    private Path mCurrentPath;
    private Iterator<Edge> mEdgeIterator;
    private final BindingSet mDelimiter;
    private BindingSet mEndBindings;

    public PathsAsTupleQueryResult(PathQueryResult thePaths) {
        this.mPaths = thePaths;
        this.mVarNames = this.createVariableNames(thePaths.getPathStartVariableNames(), thePaths.getEdgeVariableNames(), thePaths.getPathEndVariableNames());
        this.mDelimiter = BindingSets.empty();
    }

    private List<String> createVariableNames(List<String> theStartNames, List<String> theEdgeNames, List<String> theEndNames) {
        ArrayList aAll = Lists.newArrayListWithExpectedSize((int)(theStartNames.size() + theEdgeNames.size() + theEndNames.size()));
        if (theStartNames.size() > 1) {
            aAll.addAll(theStartNames.subList(1, theStartNames.size()));
        }
        aAll.add(theStartNames.get(0));
        aAll.addAll(theEdgeNames);
        aAll.add(theEndNames.get(0));
        if (theEndNames.size() > 1) {
            aAll.addAll(theEndNames.subList(1, theEndNames.size()));
        }
        return aAll;
    }

    @Nonnull
    public List<String> variables() {
        return this.mVarNames;
    }

    public void close() {
        this.mPaths.close();
    }

    public boolean hasNext() {
        block8: {
            if (this.mNextTuple != null) {
                return true;
            }
            while (this.mCurrentPath == null) {
                if (this.mPaths.hasNext()) {
                    this.mCurrentPath = (Path)this.mPaths.next();
                    this.mEdgeIterator = this.mCurrentPath.getEdges().iterator();
                    if (this.mCurrentPath.getPathEndBindings().size() > 0) {
                        this.mEndBindings = this.mCurrentPath.getPathEndBindings();
                    }
                    if (this.mCurrentPath.getPathStartBindings().size() <= 0) continue;
                    this.mNextTuple = this.mCurrentPath.getPathStartBindings();
                }
                break block8;
            }
            if (this.mEdgeIterator.hasNext()) {
                this.mNextTuple = this.mEdgeIterator.next().getBindings();
            } else if (this.mEndBindings != null) {
                this.mNextTuple = this.mEndBindings;
                this.mEndBindings = null;
            } else {
                this.mNextTuple = this.mPaths.hasNext() ? this.mDelimiter : null;
                this.mCurrentPath = null;
            }
        }
        return this.mNextTuple != null;
    }

    public BindingSet next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        BindingSet aNext = this.mNextTuple;
        this.mNextTuple = null;
        return aNext;
    }

    public void remove() throws QueryExecutionFailure {
        throw new UnsupportedOperationException("This result set is immutable");
    }
}

