/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.query;

import com.complexible.common.rdf.query.Edge;
import com.complexible.common.rdf.query.Path;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.query.BindingSet;
import com.stardog.stark.query.BindingSets;
import java.util.List;
import java.util.Objects;

public class ImmutablePath
implements Path {
    private static final BindingSet NO_BINDINGS = BindingSets.empty();
    private final List<Edge> mEdges;
    private final Value mWeight;
    private final BindingSet mPathStartBindings;
    private final BindingSet mPathEndBindings;

    public ImmutablePath(List<Edge> theEdges) {
        this(theEdges, NO_BINDINGS, NO_BINDINGS);
    }

    public ImmutablePath(List<Edge> theEdges, BindingSet thePathStartBindings, BindingSet thePathEndBindings) {
        this(theEdges, (Value)Values.literal((int)theEdges.size()), thePathStartBindings, thePathEndBindings);
    }

    public ImmutablePath(List<Edge> theEdges, Value theWeight, BindingSet thePathStartBindings, BindingSet thePathEndBindings) {
        this.mEdges = theEdges;
        this.mWeight = theWeight;
        this.mPathStartBindings = thePathStartBindings;
        this.mPathEndBindings = thePathEndBindings;
    }

    @Override
    public BindingSet getPathStartBindings() {
        return this.mPathStartBindings;
    }

    @Override
    public BindingSet getPathEndBindings() {
        return this.mPathEndBindings;
    }

    @Override
    public Value getStart() {
        return this.mEdges.get(0).getStart();
    }

    @Override
    public Value getEnd() {
        return this.mEdges.get(this.mEdges.size() - 1).getEnd();
    }

    @Override
    public List<Edge> getEdges() {
        return this.mEdges;
    }

    public Value getWeight() {
        return this.mWeight;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Path)) {
            return false;
        }
        Path that = (Path)obj;
        return Objects.equals(this.getStart(), that.getStart()) && Objects.equals(this.getEnd(), that.getEnd()) && Objects.equals(this.mEdges, that.getEdges()) && Objects.equals(this.mPathStartBindings, that.getPathStartBindings()) && Objects.equals(this.mPathEndBindings, that.getPathEndBindings());
    }

    public int hashCode() {
        return Objects.hash(this.mEdges, this.mPathStartBindings, this.mPathEndBindings);
    }

    public String toString() {
        StringBuilder aBuilder = new StringBuilder();
        for (int i = 0; i < this.mEdges.size(); ++i) {
            if (i == 0 && this.mPathStartBindings.size() > 0) {
                aBuilder.append(this.mPathStartBindings).append(" ");
            }
            aBuilder.append(this.mEdges.get(i));
            if (i == this.mEdges.size() - 1) {
                if (this.mPathEndBindings.size() <= 0) continue;
                aBuilder.append(", ").append(this.mPathEndBindings);
                continue;
            }
            aBuilder.append(", ");
        }
        return aBuilder.toString();
    }
}

