/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.query;

import com.complexible.common.rdf.query.Edge;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.query.Binding;
import com.stardog.stark.query.BindingSet;
import java.util.Objects;

public class ImmutableEdge
implements Edge {
    private static final Value ONE = Values.literal((int)1);
    private final String mStartVar;
    private final String mEndVar;
    private final BindingSet mBindings;
    private final Value mWeight;

    public ImmutableEdge(String theStartVar, String theEndVar, BindingSet theBindings) {
        this(theStartVar, theEndVar, theBindings, ONE);
    }

    private ImmutableEdge(String theStartVar, String theEndVar, BindingSet theBindings, Value theWeight) {
        this.mStartVar = theStartVar;
        this.mEndVar = theEndVar;
        this.mBindings = theBindings;
        this.mWeight = theWeight;
    }

    @Override
    public Value getStart() {
        return (Value)this.mBindings.value(this.mStartVar).get();
    }

    @Override
    public Value getEnd() {
        return (Value)this.mBindings.value(this.mEndVar).get();
    }

    @Override
    public BindingSet getBindings() {
        return this.mBindings;
    }

    public Value getWeight() {
        return this.mWeight;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Edge)) {
            return false;
        }
        Edge that = (Edge)obj;
        return Objects.equals(this.getStart(), that.getStart()) && Objects.equals(this.getEnd(), that.getEnd()) && Objects.equals(this.mBindings, that.getBindings());
    }

    public int hashCode() {
        return this.mBindings.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getStart());
        if (this.mBindings.size() > 2) {
            sb.append("-[");
            for (Binding aBinding : this.mBindings) {
                String aVar = aBinding.name();
                if (aVar.equals(this.mStartVar) || aVar.equals(this.mEndVar)) continue;
                sb.append(aVar).append("=").append(aBinding.value());
                sb.append(",");
            }
            sb.setCharAt(sb.length() - 1, ']');
        }
        sb.append("->").append(this.getEnd());
        return sb.toString();
    }
}

