/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.impl;

import com.complexible.common.base.Option;
import com.complexible.common.base.Options;
import com.complexible.common.rdf.StatementIterator;
import com.complexible.common.rdf.StatementSource;
import com.complexible.common.rdf.impl.AbstractStatementSource;
import com.complexible.common.rdf.impl.IteratorStatementSource;
import com.complexible.common.rdf.impl.MemoryStatementSource;
import com.complexible.common.rdf.impl.OneTimeStreamStatementSource;
import com.complexible.common.rdf.impl.RDFFileReference;
import com.complexible.common.rdf.impl.StreamStatementIterator;
import com.complexible.common.rdf.impl.StreamStatementSource;
import com.complexible.common.rdf.rio.ParserConfigs;
import com.complexible.common.rdf.rio.RDFStream;
import com.complexible.common.rdf.rio.RDFStreams;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.io.ByteSource;
import com.google.common.io.MoreFiles;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.io.ParserContext;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFHandlerException;
import com.stardog.stark.io.RDFWriter;
import com.stardog.stark.io.RDFWriters;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StreamStatementSources {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamStatementSources.class);
    public static final Option<Long> IN_MEMORY_LIMIT = Option.create((String)"in.memory.limit", (Object)0x100000L);

    private StreamStatementSources() {
        throw new AssertionError((Object)"No exceptions");
    }

    public static StatementSourceCreator oneTime() {
        return new OneTimeSourceCreator(ParserConfigs.defaults());
    }

    public static StatementSourceCreator oneTime(Options theParserConfig) {
        return new OneTimeSourceCreator(theParserConfig);
    }

    public static ReusableStreamSourceCreator reusable() {
        return StreamStatementSources.reusable(RDFFormats.BINARY, ParserConfigs.defaults());
    }

    public static ReusableStreamSourceCreator reusable(RDFFormat theFormat, Options theParserConfig) {
        return new ReusableStreamSourceCreator(theFormat, theParserConfig);
    }

    private static final class OneTimeSourceCreator
    implements StatementSourceCreator {
        private final Options mParserConfig;

        private OneTimeSourceCreator(Options theParserConfig) {
            this.mParserConfig = theParserConfig;
        }

        @Override
        public StatementSource create(StatementIterator theIter, Resource theContext) throws IOException {
            return new IteratorStatementSource(theIter, theContext);
        }

        @Override
        public StatementSource create(RDFFormat theInputFormat, File theFile, Resource theContext) throws IOException {
            return this.create(theInputFormat, theFile, theContext, false);
        }

        @Override
        public StatementSource create(RDFFormat theInputFormat, File theFile, Resource theContext, boolean theDeleteOnClose) throws IOException {
            if (!theFile.exists()) {
                throw new FileNotFoundException(theFile.getAbsolutePath() + " does not exist, cannot create statement source");
            }
            ListenableFuture aFuture = Futures.immediateFuture((Object)theFile.toPath());
            return new StreamStatementSource(theInputFormat, this.mParserConfig, (Future<Path>)aFuture, theContext, theDeleteOnClose);
        }

        @Override
        public StatementSource createRef(RDFFormat theInputFormat, File theFile, Resource theContext) {
            return new RDFFileReference(theFile.toPath(), theInputFormat, theContext, this.mParserConfig);
        }

        @Override
        public StatementSource create(RDFFormat theInputFormat, InputStream theStream, Resource theContext) {
            return new OneTimeStreamStatementSource(theInputFormat, theStream, this.mParserConfig, theContext);
        }

        @Override
        public StatementSource create(RDFFormat theInputFormat, ByteSource theInput, Resource theContext) throws IOException {
            return new OneTimeStreamStatementSource(theInputFormat, theInput.openBufferedStream(), this.mParserConfig, theContext);
        }
    }

    public static class ReusableStreamSourceCreator
    implements StatementSourceCreator {
        private final RDFFormat mOutputFormat;
        private final Options mParserConfig;

        ReusableStreamSourceCreator(RDFFormat theOutputFormat, Options theParserConfig) {
            this.mOutputFormat = theOutputFormat;
            this.mParserConfig = theParserConfig;
        }

        private Options newParserConfig() {
            if (this.mParserConfig.contains(ParserContext.BNODE_ID_PREFIX)) {
                LOGGER.debug("Found existing bnode prefix {}", this.mParserConfig.get(ParserContext.BNODE_ID_PREFIX));
                return this.mParserConfig;
            }
            String bnodePrefixId = ParserContext.getRandomBnodeIdPrefix();
            LOGGER.debug("Parse with new bnode prefix {}", (Object)bnodePrefixId);
            return this.mParserConfig.copy().set(ParserContext.BNODE_ID_PREFIX, (Object)bnodePrefixId);
        }

        @Override
        public StatementSource create(StatementIterator theIter, Resource theContext) throws IOException {
            Path aTemp = Files.createTempFile("statements", ".scr", new FileAttribute[0]);
            this.copy(theIter, aTemp);
            return new StreamStatementSource(this.mOutputFormat, this.newParserConfig(), (Future<Path>)Futures.immediateFuture((Object)aTemp), theContext, true);
        }

        private void copy(StatementIterator theData, Path theDest) throws IOException {
            try (BufferedOutputStream aOutput = new BufferedOutputStream(Files.newOutputStream(theDest, new OpenOption[0]));
                 StatementIterator ignored = theData;){
                RDFWriter aWriter = (RDFWriter)RDFWriters.to((OutputStream)aOutput, (RDFFormat)this.mOutputFormat).get();
                aWriter.start();
                while (theData.hasNext()) {
                    aWriter.handle((Statement)theData.next());
                }
                aWriter.end();
            }
            catch (RDFHandlerException e) {
                try {
                    Files.delete(theDest);
                }
                catch (IOException theE) {
                    LOGGER.error("Unable to delete temporary file {}", (Object)theDest, (Object)theE);
                }
                throw new IOException("Could not create a copy of the iteration: " + e.getMessage(), e);
            }
            catch (Exception e) {
                try {
                    Files.delete(theDest);
                }
                catch (IOException theE) {
                    LOGGER.error("Unable to delete temporary file {}", (Object)theDest, (Object)theE);
                }
                Throwables.throwIfInstanceOf((Throwable)e, RuntimeException.class);
                throw new IOException("There was an error consuming the input iteration: " + e.getMessage(), e);
            }
        }

        @Override
        public StatementSource createRef(RDFFormat theInputFormat, File theFile, Resource theContext) throws IOException {
            return new RDFFileReference(theFile.toPath(), theInputFormat, theContext, this.newParserConfig());
        }

        @Override
        public StatementSource create(RDFFormat theInputFormat, File theFile, Resource theContext) throws IOException {
            if (Files.size(theFile.toPath()) < (Long)this.mParserConfig.get(IN_MEMORY_LIMIT)) {
                return this.readIntoMemory(theInputFormat, MoreFiles.asByteSource((Path)theFile.toPath(), (OpenOption[])new OpenOption[0]), theContext);
            }
            return this.create(theInputFormat, theFile, theContext, false);
        }

        @Override
        public StatementSource create(RDFFormat theInputFormat, File theFile, Resource theContext, boolean theDeleteOnClose) throws IOException {
            if (!theFile.exists()) {
                throw new FileNotFoundException(theFile.getAbsolutePath() + " does not exist, cannot create statement source");
            }
            ListenableFuture aFuture = Futures.immediateFuture((Object)theFile.toPath());
            return new StreamStatementSource(theInputFormat, this.newParserConfig(), (Future<Path>)aFuture, theContext, theDeleteOnClose);
        }

        @Override
        public StatementSource create(RDFFormat theInputFormat, InputStream theStream, Resource theContext) throws IOException {
            Path aTemp = Files.createTempFile("stream", ".scr", new FileAttribute[0]);
            Files.copy(theStream, aTemp, StandardCopyOption.REPLACE_EXISTING);
            return new StreamStatementSource(theInputFormat, this.newParserConfig(), (Future<Path>)Futures.immediateFuture((Object)aTemp), theContext, true);
        }

        @Override
        public StatementSource create(final RDFFormat theFormat, final ByteSource theInput, final Resource theContext) throws IOException {
            if (((Boolean)theInput.sizeIfKnown().transform(s -> s < (Long)this.mParserConfig.get(IN_MEMORY_LIMIT)).or((Object)false)).booleanValue()) {
                return this.readIntoMemory(theFormat, theInput, theContext);
            }
            final Options newParserConfig = this.newParserConfig();
            return new AbstractStatementSource(this){

                @Override
                public StatementIterator statements() {
                    return new StreamStatementIterator(this.streams());
                }

                @Override
                public Resource getContext() {
                    return theContext;
                }

                @Override
                public List<RDFStream> streams() {
                    try {
                        return RDFStreams.forStream(theInput.openStream()).format(theFormat).context(theContext).config(newParserConfig).build();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }

                @Override
                public long estimatedCount() {
                    return (Long)theInput.sizeIfKnown().transform(size -> RDFStreams.estimatedCount(size, theFormat)).or((Object)-1L);
                }
            };
        }

        private MemoryStatementSource readIntoMemory(RDFFormat theFormat, ByteSource theSource, Resource theContext) throws IOException {
            try (InputStream aInput = theSource.openBufferedStream();){
                MemoryStatementSource memoryStatementSource = new MemoryStatementSource(RDFStreams.forStream(aInput).format(theFormat).config(this.newParserConfig()).parseInto(Lists.newArrayList()), theContext);
                return memoryStatementSource;
            }
        }
    }

    public static class StatementSourceBuilder {
        private final StatementSourceCreator creator;
        private File file;
        private InputStream stream;
        private ByteSource source;
        private RDFFormat format;
        private Resource context;

        public StatementSourceBuilder(StatementSourceCreator creator) {
            this.creator = creator;
        }

        public StatementSourceBuilder file(File file) {
            Preconditions.checkState((this.stream == null ? 1 : 0) != 0, (Object)"Cannot set both file and stream at the same time");
            Preconditions.checkState((this.source == null ? 1 : 0) != 0, (Object)"Cannot set both file and byte source at the same time");
            this.file = file;
            return this;
        }

        public StatementSourceBuilder stream(InputStream stream) {
            Preconditions.checkState((this.file == null ? 1 : 0) != 0, (Object)"Cannot set both stream and file at the same time");
            Preconditions.checkState((this.source == null ? 1 : 0) != 0, (Object)"Cannot set both stream and byte source at the same time");
            this.stream = stream;
            return this;
        }

        public StatementSourceBuilder source(ByteSource source) {
            Preconditions.checkState((this.file == null ? 1 : 0) != 0, (Object)"Cannot set both byte source and file at the same time");
            Preconditions.checkState((this.stream == null ? 1 : 0) != 0, (Object)"Cannot set both byte source and stream at the same time");
            this.source = source;
            return this;
        }

        public StatementSourceBuilder format(RDFFormat format) {
            this.format = format;
            return this;
        }

        public StatementSourceBuilder context(Resource context) {
            this.context = context;
            return this;
        }

        public StatementSource build() throws IOException {
            if (this.file != null) {
                return this.creator.create(this.format, this.file, this.context);
            }
            if (this.stream != null) {
                return this.creator.create(this.format, this.stream, this.context);
            }
            return this.creator.create(this.format, this.source, this.context);
        }

        public File getFile() {
            return this.file;
        }

        public InputStream getStream() {
            return this.stream;
        }

        public ByteSource getSource() {
            return this.source;
        }

        public RDFFormat getFormat() {
            return this.format;
        }

        public Resource getContext() {
            return this.context;
        }
    }

    public static interface StatementSourceCreator {
        public StatementSource create(StatementIterator var1, Resource var2) throws IOException;

        public StatementSource create(RDFFormat var1, File var2, Resource var3) throws IOException;

        public StatementSource create(RDFFormat var1, File var2, Resource var3, boolean var4) throws IOException;

        public StatementSource create(RDFFormat var1, InputStream var2, Resource var3) throws IOException;

        public StatementSource create(RDFFormat var1, ByteSource var2, Resource var3) throws IOException;

        public StatementSource createRef(RDFFormat var1, File var2, Resource var3) throws IOException;

        default public StatementSourceBuilder builder() {
            return new StatementSourceBuilder(this);
        }
    }
}

