/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.impl;

import com.complexible.common.base.CloseableIterator;
import com.complexible.common.base.Disposables;
import com.complexible.common.base.Options;
import com.complexible.common.rdf.StatementIterator;
import com.complexible.common.rdf.impl.StreamStatementIterator;
import com.complexible.common.rdf.rio.RDFStream;
import com.complexible.common.rdf.rio.RDFStreams;
import com.stardog.stark.Namespaces;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.impl.ImmutableNamespaces;
import com.stardog.stark.io.RDFFormat;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;

public final class StatementIterators {
    private static final StatementIterator EMPTY = new StatementIterator(){

        public Statement next() {
            throw new NoSuchElementException();
        }

        public boolean hasNext() {
            return false;
        }

        public void close() {
        }
    };

    private StatementIterators() {
        throw new AssertionError();
    }

    public static StatementIterator create(InputStream theInput, RDFFormat theFormat, Options theParserConfig) {
        return StatementIterators.create(theInput, theFormat, theParserConfig, null);
    }

    public static StatementIterator create(InputStream theInput, RDFFormat theFormat, Options theParserConfig, Resource theContext) {
        return new StreamStatementIterator(RDFStreams.forStream(theInput).format(theFormat).config(theParserConfig).context(theContext).build());
    }

    public static StatementIterator create(File theFile, RDFFormat theFormat, Options theParserConfig, Resource theContext) {
        return new StreamStatementIterator(RDFStreams.forFile(theFile.toPath()).format(theFormat).config(theParserConfig).context(theContext).build());
    }

    public static StatementIterator create(RDFStream theStream) {
        return new StreamStatementIterator(theStream);
    }

    public static StatementIterator create(RDFStream ... theStream) {
        return new StreamStatementIterator(Arrays.asList(theStream));
    }

    public static StatementIterator create(List<RDFStream> theStreams) {
        return new StreamStatementIterator(theStreams);
    }

    public static StatementIterator create(final Iterable<Statement> theStatements) {
        StatementIterator result = new StatementIterator(){
            final Iterator<Statement> mIter;
            {
                this.mIter = theStatements.iterator();
            }

            @Override
            public Namespaces namespaces() {
                return Namespaces.DEFAULT;
            }

            public Statement next() {
                return this.mIter.next();
            }

            public boolean hasNext() {
                return this.mIter.hasNext();
            }

            public void close() {
                Disposables.markReleased((Object)this);
            }
        };
        Disposables.markCreated((Object)result);
        return result;
    }

    public static StatementIterator empty() {
        return EMPTY;
    }

    public static StatementIterator create(CloseableIterator<Statement> theIterator) {
        return StatementIterators.create(theIterator, ImmutableNamespaces.empty());
    }

    public static StatementIterator create(final CloseableIterator<Statement> theIterator, final Namespaces theNamespaces) {
        StatementIterator result = new StatementIterator(){

            @Override
            public Namespaces namespaces() {
                return theNamespaces;
            }

            public Statement next() {
                return (Statement)theIterator.next();
            }

            public boolean hasNext() {
                return theIterator.hasNext();
            }

            public void close() {
                Disposables.markReleased((Object)this);
                theIterator.close();
            }
        };
        Disposables.markCreated((Object)result);
        return result;
    }

    public static StatementIterator transform(final StatementIterator theIter, final Function<Statement, Statement> theFunction) {
        StatementIterator result = new StatementIterator(){

            @Override
            public Namespaces namespaces() {
                return theIter.namespaces();
            }

            public Statement next() {
                return (Statement)theFunction.apply((Statement)theIter.next());
            }

            public boolean hasNext() {
                return theIter.hasNext();
            }

            public void close() {
                Disposables.markReleased((Object)this);
                theIter.close();
            }
        };
        Disposables.markCreated((Object)result);
        return result;
    }

    public static StatementIterator withNamespaces(final StatementIterator theIter, final Namespaces theNamespaces) {
        return new StatementIterator(){

            @Override
            public Namespaces namespaces() {
                return ImmutableNamespaces.of((Iterable)theIter.namespaces(), (Iterable[])new Iterable[]{theNamespaces});
            }

            public Statement next() {
                return (Statement)theIter.next();
            }

            public boolean hasNext() {
                return theIter.hasNext();
            }

            public void close() {
                theIter.close();
            }
        };
    }
}

