/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.impl;

import com.complexible.common.rdf.StatementIterator;
import com.complexible.common.rdf.impl.AbstractStatementSource;
import com.complexible.common.rdf.impl.DefaultStatementIterator;
import com.complexible.common.rdf.rio.RDFStream;
import com.complexible.common.rdf.rio.RDFStreams;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Statements;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class MemoryStatementSource
extends AbstractStatementSource {
    private final Iterable<Statement> mGraph;
    private final Resource mContext;
    private boolean mClosed;

    public MemoryStatementSource(Iterable<Statement> theGraph) {
        this(theGraph, null);
    }

    public MemoryStatementSource(Iterable<Statement> theGraph, Resource theContext) {
        Preconditions.checkNotNull(theGraph);
        this.mContext = theContext;
        if (this.mContext == null) {
            this.mGraph = theGraph;
        } else {
            Function aApplyContext = stmt -> (Statement)Statements.APPLY_CONTEXT.apply(stmt, theContext);
            this.mGraph = theGraph instanceof Collection ? Collections2.transform((Collection)((Collection)theGraph), (Function)aApplyContext) : Iterables.transform(theGraph, (Function)aApplyContext);
        }
    }

    @Override
    public StatementIterator statements() {
        if (this.mClosed) {
            throw new IllegalStateException("Closed statement source");
        }
        return new DefaultStatementIterator(this.mGraph);
    }

    @Override
    public void close() {
        this.mClosed = true;
    }

    @Override
    public Resource getContext() {
        return this.mContext;
    }

    public boolean equals(Object theObj) {
        if (this == theObj) {
            return true;
        }
        if (theObj == null || this.getClass() != theObj.getClass()) {
            return false;
        }
        MemoryStatementSource that = (MemoryStatementSource)theObj;
        return Objects.equals(this.mContext, that.mContext) && Iterables.elementsEqual(this.mGraph, that.mGraph);
    }

    public int hashCode() {
        return Objects.hash(this.mGraph, this.mContext);
    }

    @Override
    public List<RDFStream> streams() {
        return ImmutableList.of((Object)RDFStreams.forStatements(this.mGraph, this.getContext()));
    }

    public String toString() {
        return "MemoryStatementSource{" + (this.mGraph instanceof Collection ? ((Collection)this.mGraph).size() : Iterables.size(this.mGraph)) + " triples" + (String)(this.mContext == null ? "" : ", in " + String.valueOf(this.mContext)) + "}";
    }

    @Override
    public long estimatedCount() {
        return this.mGraph instanceof Collection ? (long)((Collection)this.mGraph).size() : -1L;
    }

    @Override
    public boolean inMemory() {
        return true;
    }

    public static MemoryStatementSource of(Iterable<Statement> theGraph) {
        return new MemoryStatementSource(theGraph);
    }

    public static MemoryStatementSource of(Iterable<Statement> theGraph, Resource theContext) {
        return new MemoryStatementSource(theGraph, theContext);
    }
}

