/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.Disposables;
import com.complexible.common.rdf.StatementIterator;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.stardog.stark.Namespace;
import com.stardog.stark.Namespaces;
import com.stardog.stark.Statement;
import com.stardog.stark.impl.NamespacesImpl;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class MultiStatementIterator
extends AbstractIterator<Statement>
implements StatementIterator {
    private final Namespaces mNamespaces;
    private Iterator<Statement> mCurr;
    private final List<StatementIterator> mIters;
    private int mIndex = 0;

    public MultiStatementIterator(List<StatementIterator> theIters) {
        this.mNamespaces = MultiStatementIterator.collectNamespaces(theIters);
        this.mIters = theIters;
        this.mCurr = ImmutableSet.of().iterator();
        Disposables.markCreated((Object)this);
    }

    private static Namespaces collectNamespaces(Iterable<StatementIterator> theIters) {
        NamespacesImpl aNamespaces = new NamespacesImpl();
        HashSet aSeenPrefixes = Sets.newHashSet();
        for (StatementIterator aIter : theIters) {
            for (Namespace ns : aIter.namespaces()) {
                if (!aSeenPrefixes.add(ns.prefix())) continue;
                aNamespaces.add(ns);
                if (aNamespaces.size() <= 100) continue;
                return aNamespaces;
            }
        }
        return aNamespaces;
    }

    protected Statement computeNext() {
        while (this.mCurr.hasNext() || this.mIndex < this.mIters.size()) {
            if (this.mCurr.hasNext()) {
                return this.mCurr.next();
            }
            if (this.mIndex >= this.mIters.size()) continue;
            this.mCurr = (Iterator)((Object)this.mIters.get(this.mIndex++));
        }
        return (Statement)this.endOfData();
    }

    public void close() throws RuntimeException {
        Disposables.markReleased((Object)this);
        AutoCloser.close(this.mIters);
    }

    @Override
    public Namespaces namespaces() {
        return this.mNamespaces;
    }
}

