/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf;

import com.complexible.common.base.Disposables;
import com.complexible.common.rdf.DelegatingStatementSource;
import com.complexible.common.rdf.StatementIterator;
import com.complexible.common.rdf.StatementSource;
import com.complexible.common.rdf.rio.DelegatingRDFStream;
import com.complexible.common.rdf.rio.RDFStream;
import com.google.common.collect.Lists;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Statements;
import com.stardog.stark.io.InvalidRDF;
import com.stardog.stark.io.RDFHandler;
import com.stardog.stark.io.RDFHandlerException;
import com.stardog.stark.io.TransformingRDFHandler;
import java.io.IOException;
import java.util.List;

public class ContextOverrideStatementSource
extends DelegatingStatementSource {
    private final Resource mContext;

    ContextOverrideStatementSource(StatementSource theStatementSource, Resource theContext) {
        super(theStatementSource);
        this.mContext = theContext;
    }

    @Override
    public Resource getContext() {
        return this.mContext;
    }

    @Override
    public StatementIterator statements() {
        final StatementIterator aIter = super.statements();
        return (StatementIterator)Disposables.markCreated((Object)new StatementIterator(){

            public Statement next() {
                return (Statement)Statements.APPLY_CONTEXT.apply((Statement)aIter.next(), ContextOverrideStatementSource.this.mContext);
            }

            public boolean hasNext() {
                return aIter.hasNext();
            }

            public void close() {
                Disposables.markReleased((Object)this);
                aIter.close();
            }
        });
    }

    @Override
    public List<RDFStream> streams() {
        return Lists.transform(super.streams(), rdfStream -> new DelegatingRDFStream((RDFStream)rdfStream){

            @Override
            public void parse(RDFHandler theHandler) throws IOException, InvalidRDF, RDFHandlerException {
                super.parse((RDFHandler)new TransformingRDFHandler(theHandler, Statements.applyContext((Resource)ContextOverrideStatementSource.this.mContext)));
            }
        });
    }
}

