/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf;

import com.complexible.common.base.Disposables;
import com.complexible.common.rdf.DelegatingStatementSource;
import com.complexible.common.rdf.StatementIterator;
import com.complexible.common.rdf.StatementSource;
import com.complexible.common.rdf.rio.RDFStream;
import com.complexible.common.rdf.rio.RDFStreams;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.stardog.stark.IRI;
import com.stardog.stark.Namespaces;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import java.util.Iterator;
import java.util.List;

public class ContextFallbackStatementSource
extends DelegatingStatementSource {
    private final Resource mContext;

    public ContextFallbackStatementSource(StatementSource theStatementSource, Resource theContext) {
        super(theStatementSource);
        Preconditions.checkNotNull((Object)theContext, (Object)"Fallback context cannot be null");
        this.mContext = theContext;
    }

    @Override
    public List<RDFStream> streams() {
        return ImmutableList.of((Object)RDFStreams.forStatements((Iterator<Statement>)((Object)this.statements()), null, this.estimatedCount()));
    }

    @Override
    public StatementIterator statements() {
        return new ContextFallbackStatementIterator(super.statements(), this.mContext);
    }

    private static class ContextFallbackStatementIterator
    implements StatementIterator {
        private final StatementIterator mIter;
        private final Resource mContext;

        ContextFallbackStatementIterator(StatementIterator theIter, Resource theContext) {
            this.mIter = theIter;
            this.mContext = theContext;
            Disposables.markCreated((Object)this);
        }

        @Override
        public Namespaces namespaces() {
            return this.mIter.namespaces();
        }

        public Statement next() {
            Statement aStmt = (Statement)this.mIter.next();
            return aStmt.context() != Values.DEFAULT_GRAPH ? aStmt : Values.statement((Resource)aStmt.subject(), (IRI)aStmt.predicate(), (Value)aStmt.object(), (Resource)this.mContext);
        }

        public boolean hasNext() {
            return this.mIter.hasNext();
        }

        public void close() {
            Disposables.markReleased((Object)this);
            this.mIter.close();
        }
    }
}

