/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io.rdfjson;

import com.complexible.common.base.Options;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.stardog.stark.BNode;
import com.stardog.stark.IRI;
import com.stardog.stark.Resource;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.io.IOParserContext;
import com.stardog.stark.io.InvalidRDF;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFHandler;
import com.stardog.stark.io.RDFParser;
import com.stardog.stark.io.rdfjson.RDFJSON;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import javax.annotation.Nonnull;
import org.apache.commons.io.input.BOMInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RDFJSONParser
implements RDFParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(RDFJSONParser.class);

    @Nonnull
    public RDFFormat format() {
        return RDFFormats.RDFJSON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(@Nonnull InputStream theStream, @Nonnull RDFHandler theHandler, @Nonnull Options theOptions) throws IOException {
        JsonParser jp = null;
        IOParserContext aParserContext = new IOParserContext((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), this.format().charset()), theHandler, theOptions);
        try {
            theHandler.start();
            jp = RDFJSON.JSON_FACTORY.createParser((InputStream)new BOMInputStream(theStream, false));
            this.rdfJsonToHandlerInternal(aParserContext, jp);
        }
        finally {
            if (jp != null) {
                try {
                    jp.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Found exception while closing JSON parser", (Throwable)e);
                }
            }
        }
        theHandler.end();
    }

    private void rdfJsonToHandlerInternal(IOParserContext theContext, JsonParser jp) throws IOException {
        if (jp.nextToken() != JsonToken.START_OBJECT) {
            throw new InvalidRDF("Expected RDF/JSON document to start with an Object", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
        }
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            IRI subject;
            String subjStr = jp.getCurrentName();
            Object object = subject = subjStr.startsWith("_:") ? theContext.createBNode(subjStr.substring(2)) : Values.iri((String)subjStr);
            if (jp.nextToken() != JsonToken.START_OBJECT) {
                throw new InvalidRDF("Expected subject value to start with an Object", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
            }
            boolean foundPredicate = false;
            while (jp.nextToken() != JsonToken.END_OBJECT) {
                String predStr = jp.getCurrentName();
                IRI predicate = Values.iri((String)predStr);
                foundPredicate = true;
                if (jp.nextToken() != JsonToken.START_ARRAY) {
                    throw new InvalidRDF("Expected predicate value to start with an array", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                }
                boolean foundObject = false;
                while (jp.nextToken() != JsonToken.END_ARRAY) {
                    if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
                        throw new InvalidRDF("Expected object value to start with an Object: subject=<" + subjStr + "> predicate=<" + predStr + ">", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                    }
                    String nextValue = null;
                    String nextType = null;
                    String nextDatatype = null;
                    String nextLanguage = null;
                    HashSet<String> nextContexts = new HashSet<String>(2);
                    while (jp.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = jp.getCurrentName();
                        if ("value".equals(fieldName)) {
                            if (nextValue != null) {
                                throw new InvalidRDF("Multiple values found for a single object: subject=" + subjStr + " predicate=" + predStr, (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                            }
                            jp.nextToken();
                            nextValue = jp.getText();
                            continue;
                        }
                        if ("type".equals(fieldName)) {
                            if (nextType != null) {
                                throw new InvalidRDF("Multiple types found for a single object: subject=" + subjStr + " predicate=" + predStr, (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                            }
                            jp.nextToken();
                            nextType = jp.getText();
                            continue;
                        }
                        if ("lang".equals(fieldName)) {
                            if (nextLanguage != null) {
                                throw new InvalidRDF("Multiple languages found for a single object: subject=" + subjStr + " predicate=" + predStr, (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                            }
                            jp.nextToken();
                            nextLanguage = jp.getText();
                            continue;
                        }
                        if ("datatype".equals(fieldName)) {
                            if (nextDatatype != null) {
                                throw new InvalidRDF("Multiple datatypes found for a single object: subject=" + subjStr + " predicate=" + predStr, (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                            }
                            jp.nextToken();
                            nextDatatype = jp.getText();
                            continue;
                        }
                        if ("graphs".equals(fieldName)) {
                            if (jp.nextToken() != JsonToken.START_ARRAY) {
                                throw new InvalidRDF("Expected graphs to start with an array", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                            }
                            while (jp.nextToken() != JsonToken.END_ARRAY) {
                                String nextGraph = jp.getText();
                                nextContexts.add(nextGraph);
                            }
                            continue;
                        }
                        throw new InvalidRDF("Unrecognised JSON field name for object: subject=" + subjStr + " predicate=" + predStr + " fieldname=" + fieldName, (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                    }
                    BNode object2 = null;
                    if (nextType == null) {
                        throw new InvalidRDF("No type for object: subject=" + subjStr + " predicate=" + predStr, (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                    }
                    if (nextValue == null) {
                        throw new InvalidRDF("No value for object: subject=" + subjStr + " predicate=" + predStr, (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                    }
                    if ("literal".equals(nextType)) {
                        theContext.mLineNumber = jp.getCurrentLocation().getLineNr();
                        theContext.mColumnNumber = jp.getCurrentLocation().getColumnNr();
                        object2 = nextLanguage != null ? theContext.createLiteral(nextValue, nextLanguage, null) : (nextDatatype != null ? theContext.createLiteral(nextValue, null, Values.iri((String)nextDatatype)) : theContext.createLiteral(nextValue, null, null));
                    } else if ("bnode".equals(nextType)) {
                        if (nextLanguage != null) {
                            throw new InvalidRDF("Language was attached to a blank node object: subject=" + subjStr + " predicate=" + predStr, (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                        }
                        if (nextDatatype != null) {
                            throw new InvalidRDF("Datatype was attached to a blank node object: subject=" + subjStr + " predicate=" + predStr, (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                        }
                        object2 = theContext.createBNode(nextValue.substring(2));
                    } else if ("uri".equals(nextType)) {
                        if (nextLanguage != null) {
                            throw new InvalidRDF("Language was attached to a uri object: subject=" + subjStr + " predicate=" + predStr, (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                        }
                        if (nextDatatype != null) {
                            throw new InvalidRDF("Datatype was attached to a uri object: subject=" + subjStr + " predicate=" + predStr, (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                        }
                        object2 = Values.iri((String)nextValue);
                    }
                    foundObject = true;
                    if (!nextContexts.isEmpty()) {
                        for (String nextContext : nextContexts) {
                            Object context = nextContext.equals("null") ? null : (nextContext.startsWith("_:") ? theContext.createBNode(nextContext.substring(2)) : Values.iri((String)nextContext));
                            theContext.handle(Values.statement((Resource)subject, (IRI)predicate, (Value)object2, (Resource)context));
                        }
                        continue;
                    }
                    theContext.handle(Values.statement((Resource)subject, (IRI)predicate, (Value)object2));
                }
                if (foundObject) continue;
                throw new InvalidRDF("No object for predicate: subject=" + subjStr + " predicate=" + predStr, (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
            }
            if (foundPredicate) continue;
            throw new InvalidRDF("No predicate for object: subject=" + subjStr, (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
        }
    }
}

