/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.protocols.http.client.graphql;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.graphql.GraphQLConnection;
import com.complexible.stardog.api.graphql.GraphQLQuery;
import com.complexible.stardog.api.impl.DelegatingConnection;
import com.complexible.stardog.api.impl.GraphQLExecutor;
import com.complexible.stardog.api.impl.GraphQLQueryImpl;
import com.complexible.stardog.graphql.GraphQLGenericError;
import com.complexible.stardog.graphql.GraphQLSchemaManager;
import com.complexible.stardog.graphql.GraphQLSchemas;
import com.complexible.stardog.graphql.GraphQLUtil;
import com.complexible.stardog.protocols.http.ReplicationUtils;
import com.complexible.stardog.protocols.http.client.ApacheHttp;
import com.complexible.stardog.protocols.http.client.HttpClient;
import com.complexible.stardog.protocols.http.client.HttpConnection;
import com.complexible.stardog.protocols.http.client.HttpOptions;
import com.complexible.stardog.protocols.http.graphql.shared.JsonUtil;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import graphql.ErrorType;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLError;
import graphql.language.SourceLocation;
import graphql.schema.GraphQLSchema;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;

public class GraphQLHttpConnection
extends DelegatingConnection
implements GraphQLConnection,
GraphQLExecutor {
    private static final Function<String, Void> NO_RESULT = null;

    public GraphQLHttpConnection(Connection theConnection) {
        super(theConnection);
    }

    protected HttpConnection getConnection() {
        return (HttpConnection)super.getConnection();
    }

    protected HttpConnection getOpenConnection() throws StardogException {
        HttpConnection aConn = (HttpConnection)super.getConnection();
        Preconditions.checkState((boolean)aConn.isOpen(), (Object)"Connection is closed");
        return aConn;
    }

    public GraphQLQuery graphql(String theQuery) throws StardogException {
        return new GraphQLQueryImpl((GraphQLExecutor)this, this.isReasoningEnabled(), theQuery);
    }

    public GraphQLSchemaManager schemas() {
        return new GraphQLSchemaManager(){

            public GraphQLSchema getSchema(String name) throws StardogException {
                String aPath = "graphql/schemas/" + name;
                return GraphQLHttpConnection.this.executeRequest(HttpMethod.GET, aPath, GraphQLSchemas::read);
            }

            public Iterable<String> getSchemas() throws StardogException {
                String aPath = "graphql/schemas";
                Map aMap = GraphQLHttpConnection.this.executeRequest(HttpMethod.GET, aPath, JsonUtil::fromJson);
                return (List)aMap.get("schemas");
            }

            public void addSchema(String name, GraphQLSchema schema) throws StardogException {
                String aPath = "graphql/schemas/" + name;
                HttpClient aClient = GraphQLHttpConnection.this.getOpenConnection().getClient();
                String aURL = aClient.url(aPath);
                HttpPost aPost = new HttpPost(aURL);
                aPost.setEntity((HttpEntity)new StringEntity(GraphQLSchemas.write((GraphQLSchema)schema), Charsets.UTF_8));
                GraphQLHttpConnection.this.executeRequest(aClient, (ClassicHttpRequest)aPost, NO_RESULT);
            }

            public void updateSchema(String name, GraphQLSchema schema) throws StardogException {
                String aPath = "graphql/schemas/" + name;
                HttpClient aClient = GraphQLHttpConnection.this.getOpenConnection().getClient();
                String aURL = aClient.url(aPath);
                HttpPut aPut = new HttpPut(aURL);
                aPut.setEntity((HttpEntity)new StringEntity(GraphQLSchemas.write((GraphQLSchema)schema), Charsets.UTF_8));
                GraphQLHttpConnection.this.executeRequest(aClient, (ClassicHttpRequest)aPut, NO_RESULT);
            }

            public void removeSchema(String name) throws StardogException {
                String aPath = "graphql/schemas/" + name;
                GraphQLHttpConnection.this.executeRequest(HttpMethod.DELETE, aPath, NO_RESULT);
            }

            public void clearSchemas() throws StardogException {
                String aPath = "graphql/schemas";
                GraphQLHttpConnection.this.executeRequest(HttpMethod.DELETE, aPath, NO_RESULT);
            }
        };
    }

    public ExecutionResult execute(GraphQLQuery theQuery) throws StardogException {
        return this.executeQuery(false, theQuery);
    }

    public String explain(GraphQLQuery theQuery) {
        ExecutionResult aResult = this.executeQuery(true, theQuery);
        return GraphQLUtil.formatExplainResult((ExecutionResult)aResult);
    }

    private ExecutionResult executeQuery(boolean isExplain, GraphQLQuery theQuery) {
        JsonParameterBuilder aBuilder = new JsonParameterBuilder();
        aBuilder.parameter("query", theQuery.queryString());
        HashMap aVariables = Maps.newHashMap((Map)theQuery.variables());
        if (isExplain) {
            aVariables.put("@explain", true);
        }
        if (theQuery.isReasoningEnabled()) {
            aVariables.put("@reasoning", true);
        }
        if (!aVariables.isEmpty()) {
            aBuilder.parameter("variables", aVariables);
        }
        if (theQuery.timeout() != -1L) {
            aBuilder.parameter("timeout", String.valueOf(theQuery.timeout()));
        }
        boolean isGet = theQuery.queryString().length() < (Integer)this.getConnection().getConnectionOptions().get(HttpOptions.HTTP_MAX_HTTP_GET_QUERY_LENGTH);
        HttpMethod aMethod = isGet ? HttpMethod.GET : HttpMethod.POST;
        Object aPath = "graphql";
        if (theQuery.schema() != null) {
            aPath = (String)aPath + "/" + theQuery.schema();
        }
        Map aMap = this.executeRequest(aMethod, (String)aPath, aBuilder, JsonUtil::fromJson);
        Object aData = aMap.get("data");
        List<GraphQLError> aErrors = this.parseErrors(aMap.get("errors"));
        return new ExecutionResultImpl(aData, aErrors);
    }

    private <T> T executeRequest(HttpMethod theMethod, String theRelativePath, Function<String, T> theTransformer) {
        return this.executeRequest(theMethod, theRelativePath, ApacheHttp.Parameters.builder(), theTransformer);
    }

    private <T> T executeRequest(HttpMethod theMethod, String theRelativePath, ApacheHttp.Parameters.ParameterListBuilder theParams, Function<String, T> theTransformer) {
        HttpClient aClient = this.getOpenConnection().getClient();
        String aURL = aClient.url(theRelativePath);
        URI aReqURI = theParams.uri(aURL);
        return this.executeRequest(aClient, (ClassicHttpRequest)(switch (theMethod.ordinal()) {
            case 0 -> new HttpGet(aReqURI);
            case 3 -> new HttpDelete(aReqURI);
            case 1 -> {
                HttpPost post = new HttpPost(aURL);
                post.setEntity(theParams.postBody());
                yield post;
            }
            case 2 -> {
                HttpPut put = new HttpPut(aURL);
                put.setEntity((HttpEntity)new StringEntity(((NameValuePair)theParams.build().get(0)).getValue(), Charsets.UTF_8));
                yield put;
            }
            default -> throw new IllegalArgumentException();
        }), theTransformer);
    }

    private <T> T executeRequest(HttpClient theClient, ClassicHttpRequest theRequest, Function<String, T> theTransformer) {
        ((Optional)ReplicationUtils.OPTIONAL_ADMIN_TX_ID.get()).ifPresent(v -> theRequest.addHeader("SD-Admin-TxId", v));
        CloseableHttpResponse aResponse = theClient.execute(theRequest);
        HttpEntity aEntity = null;
        try {
            aEntity = aResponse.getEntity();
            if (theTransformer == null) {
                EntityUtils.consumeQuietly((HttpEntity)aEntity);
                T t = null;
                return t;
            }
            T t = theTransformer.apply(EntityUtils.toString((HttpEntity)aEntity, (Charset)Charsets.UTF_8));
            return t;
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
        finally {
            if (aEntity != null) {
                EntityUtils.consumeQuietly((HttpEntity)aEntity);
            }
        }
    }

    private List<GraphQLError> parseErrors(Object theObject) {
        ArrayList aErrors = Lists.newArrayList();
        if (theObject != null) {
            try {
                List aList = (List)theObject;
                for (Map aEntry : aList) {
                    String aMsg = (String)aEntry.get("message");
                    List aLocations = ((List)aEntry.getOrDefault("locations", ImmutableList.of())).stream().map(aLocation -> new SourceLocation(((Integer)aLocation.get("line")).intValue(), ((Integer)aLocation.get("column")).intValue())).collect(Collectors.toList());
                    ErrorType aErrorType = ErrorType.InvalidSyntax;
                    Object aExtensions = aEntry.get("extensions");
                    if (aExtensions != null && aExtensions instanceof Map) {
                        String aError = ((Map)aExtensions).getOrDefault("classification", ErrorType.InvalidSyntax.name());
                        try {
                            aErrorType = ErrorType.valueOf((String)aError);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    aErrors.add(GraphQLGenericError.create((String)aMsg, aLocations, (ErrorType)aErrorType));
                }
            }
            catch (Exception e) {
                aErrors.add(GraphQLGenericError.create((String)("Cannot translate error message: " + String.valueOf(e) + "\n" + String.valueOf(theObject))));
            }
        }
        return aErrors;
    }

    private static class JsonParameterBuilder
    extends ApacheHttp.Parameters.ParameterListBuilder {
        private final Map<String, Object> params = Maps.newHashMap();

        private JsonParameterBuilder() {
        }

        public ApacheHttp.Parameters.ParameterListBuilder parameter(String theKey, String theValue) {
            this.params.put(theKey, theValue);
            return super.parameter(theKey, theValue);
        }

        public ApacheHttp.Parameters.ParameterListBuilder parameter(String theKey, boolean theValue) {
            this.params.put(theKey, theValue);
            return super.parameter(theKey, theValue);
        }

        public ApacheHttp.Parameters.ParameterListBuilder parameter(String theKey, Map<String, Object> theValue) {
            this.params.put(theKey, theValue);
            return super.parameter(theKey, JsonUtil.toJson(theValue));
        }

        public HttpEntity postBody() {
            return new StringEntity(JsonUtil.toJson(this.params), ContentType.APPLICATION_JSON);
        }
    }

    private static enum HttpMethod {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

