/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.search.cli;

import com.complexible.common.base.CloseableIterator;
import com.complexible.common.base.Numbers;
import com.complexible.common.dataexporter.TextTabularOutput;
import com.complexible.common.rdf.rio.TurtleValueWriter;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.search.SearchConnection;
import com.complexible.stardog.api.search.SearchResult;
import com.complexible.stardog.api.search.SearchResults;
import com.complexible.stardog.api.search.Searcher;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.CliUtil;
import com.complexible.stardog.cli.impl.SimpleQueryCommand;
import com.google.inject.Inject;
import com.stardog.stark.IRI;
import com.stardog.stark.Namespaces;
import com.stardog.stark.Resource;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.query.QueryExecutionFailure;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.OutputStream;
import java.util.List;

@Command(name="search", description="Performs a full-text search over the database; prints results on STDOUT.", discussion="Uses Waldo, the Stardog Lucene integration, to perform a full-text search over the contents of the database.  This will return all individuals which have a literal whose value which matches the input search term.  Because the search is over the literal values, but this function returns individuals, you can see repeated individuals when an one has multiple values which match the search term.  If you want to retrieve the literals instead, or want to perform more sophisticated filtering, you can use the SPARQL search syntax which is explained in more detail at http://docs.stardog.com/#_searching.", examples={"* Perform the default search", "    $ stardog query search -q 'the search string' myDb", "", "* Perform a search with a minimum threshold and maximum number of results", "    $ stardog query search -q 'the search string' -l 100 -t 5 myDb"})
public final class Search
extends SimpleQueryCommand<Void> {
    @Option(name={"-q", "--query"}, description="Search query in standard Lucene query syntax.  More information about Lucene query syntax at http://bit.ly/Z02mfV", title="query", required=true)
    public String mQuery;
    @Option(name={"-l", "--limit"}, description="Max number of search results; default: 50.", title="limit")
    public Integer mLimit;
    @Option(name={"-o", "--offset"}, description="Offset search results; default 0.", title="offset")
    public Integer mOffset;
    @Option(name={"-t", "--threshold"}, description="Minimum score threshold for results", title="threshold")
    public Double mThreshold;
    @Option(name={"-g", "--named-graph", "--named-graphs"}, title="named graphs", arity=0x7FFFFFFF, description="Named graph(s) to search.  Multiple graphs are separated by whitespaces, e.g., '-g \"urn:context1 urn:context2\"'. The keyword 'ALL' can be used to denote the entire database, 'NAMED' for only the named graphs, and 'DEFAULT' for the default graph. By default, searches are only over the default graph.  When used as the last option, values should be followed by '--' to denote the end of the named graphs.")
    public List<String> mGraphs;

    @Inject
    public Search(PasswordReader theReader) {
        super(theReader);
    }

    public void execute(Connection theConn) throws StardogException {
        if (this.mQuery == null || this.mQuery.trim().equals("")) {
            throw new StardogException(Search.get((String)"search.error.noquery", (Object[])new Object[0]));
        }
        Searcher aSearcher = ((SearchConnection)theConn.as(SearchConnection.class)).search();
        if (this.mLimit != null) {
            aSearcher.limit(this.mLimit.intValue());
        }
        if (this.mOffset != null) {
            aSearcher.offset(this.mOffset.intValue());
        }
        if (this.mThreshold != null) {
            aSearcher.threshold(this.mThreshold.doubleValue());
        }
        if (this.mGraphs != null) {
            IRI[] aGraphs = new IRI[this.mGraphs.size()];
            for (int i = 0; i < this.mGraphs.size(); ++i) {
                aGraphs[i] = Values.iri((String)this.mGraphs.get(i));
            }
            aSearcher.in((Resource[])aGraphs);
        }
        aSearcher.query(this.mQuery.trim());
        SearchResults aResults = aSearcher.search();
        try (CloseableIterator resultIt = aResults.iterator();){
            if (!resultIt.hasNext()) {
                System.out.println(Search.get((String)"search.msg.noresults", (Object[])new Object[0]));
            } else {
                Namespaces aNamespaces = CliUtil.namespaces((Connection)theConn);
                TurtleValueWriter aWriter = new TurtleValueWriter((Iterable)aNamespaces);
                String[] aCols = new String[]{Search.get((String)"search.msg.index", (Object[])new Object[0]), Search.get((String)"search.msg.score", (Object[])new Object[0]), Search.get((String)"search.msg.hit", (Object[])new Object[0])};
                TextTabularOutput aTable = new TextTabularOutput((OutputStream)System.out, aCols);
                while (resultIt.hasNext()) {
                    SearchResult aResult = (SearchResult)resultIt.next();
                    aTable.addRow(new Object[]{aResult.getIndex() + 1, Numbers.readable((double)aResult.getScore()), Search.formatResource(aResult.getHit(), aWriter)});
                }
                aTable.output();
            }
        }
        catch (QueryExecutionFailure e) {
            throw new StardogException((Throwable)e);
        }
    }

    private static String formatResource(Resource theResource, TurtleValueWriter theWriter) {
        if (theResource instanceof IRI) {
            String str = theWriter.write((Value)theResource);
            return str.charAt(0) == '<' ? str.substring(1, str.length() - 1) : str;
        }
        return Value.lex((Value)theResource);
    }

    protected String connectionString() {
        return this.mDbName;
    }
}

