/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.graphql;

import com.complexible.stardog.graphql.GraphQLWrappedException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import com.stardog.stark.Datatype;
import com.stardog.stark.Literal;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import graphql.ExecutionResult;
import graphql.Scalars;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.ListType;
import graphql.language.Node;
import graphql.language.NonNullType;
import graphql.language.StringValue;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.schema.GraphQLModifiedType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.json.JSONObject;

public class GraphQLUtil {
    private static Map<GraphQLScalarType, Function<Literal, Object>> SCALAR_TRANSLATORS = ImmutableMap.builder().put((Object)Scalars.GraphQLInt, Literal::intValue).put((Object)Scalars.GraphQLBoolean, Literal::booleanValue).put((Object)Scalars.GraphQLFloat, Literal::floatValue).put((Object)Scalars.GraphQLID, Value::lex).put((Object)Scalars.GraphQLString, Value::lex).build();

    public static Value translateGraphQLValue(graphql.language.Value value) {
        if (value instanceof BooleanValue) {
            return Values.literal((boolean)((BooleanValue)value).isValue());
        }
        if (value instanceof IntValue) {
            return Values.literal((BigInteger)((IntValue)value).getValue());
        }
        if (value instanceof FloatValue) {
            return Values.literal((BigDecimal)((FloatValue)value).getValue());
        }
        if (value instanceof StringValue) {
            return Values.literal((String)((StringValue)value).getValue());
        }
        if (value instanceof EnumValue) {
            return Values.iri((String)("http://api.stardog.com/" + ((EnumValue)value).getName()));
        }
        throw GraphQLWrappedException.create((Node)value, "Unsupported value type: " + String.valueOf(value));
    }

    public static Value translateVariableValue(Object value, Type type, Function<String, Value> iriResolver) {
        String typeName = GraphQLUtil.getTypeName(type);
        if (typeName.equals(Scalars.GraphQLBoolean.getName())) {
            return Values.literal((boolean)((Boolean)value));
        }
        if (typeName.equals(Scalars.GraphQLInt.getName())) {
            return Values.literal((long)((Number)value).longValue(), (Datatype)Datatype.INTEGER);
        }
        if (typeName.equals(Scalars.GraphQLFloat.getName())) {
            return Values.literal((double)((Number)value).doubleValue());
        }
        if (typeName.equals(Scalars.GraphQLString.getName())) {
            return Values.literal((String)value.toString());
        }
        if (typeName.equals(Scalars.GraphQLID.getName())) {
            String str = value.toString();
            return iriResolver.apply(str);
        }
        throw new IllegalArgumentException("Unsupported value type: " + String.valueOf(value));
    }

    private static String getTypeName(Type type) {
        if (type instanceof ListType) {
            throw new IllegalArgumentException("List type not supported: " + String.valueOf(type));
        }
        if (type instanceof NonNullType) {
            return GraphQLUtil.getTypeName(((NonNullType)type).getType());
        }
        if (type instanceof TypeName) {
            return ((TypeName)type).getName();
        }
        throw new IllegalArgumentException("Unrecognized type: " + String.valueOf(type));
    }

    public static Object translateLiteral(Literal lit, GraphQLType type) {
        Function<Literal, Object> translator = SCALAR_TRANSLATORS.get(type);
        if (translator != null) {
            return translator.apply(lit);
        }
        return GraphQLUtil.translateLiteral(lit);
    }

    public static Object translateLiteral(Literal lit) {
        Datatype dt = lit.datatype();
        switch (dt) {
            case BOOLEAN: {
                return Literal.booleanValue((Literal)lit);
            }
            case DOUBLE: {
                return Literal.doubleValue((Literal)lit);
            }
            case FLOAT: {
                return Float.valueOf(Literal.floatValue((Literal)lit));
            }
            case INT: 
            case INTEGER: 
            case LONG: 
            case BYTE: 
            case SHORT: 
            case NON_POSITIVE_INTEGER: 
            case NEGATIVE_INTEGER: 
            case NON_NEGATIVE_INTEGER: 
            case POSITIVE_INTEGER: 
            case UNSIGNED_INT: 
            case UNSIGNED_SHORT: 
            case UNSIGNED_BYTE: 
            case UNSIGNED_LONG: {
                return Ints.saturatedCast((long)Literal.longValue((Literal)lit));
            }
        }
        return Value.lex((Value)lit);
    }

    public static GraphQLType getBaseType(GraphQLType type) {
        while (type instanceof GraphQLModifiedType) {
            type = ((GraphQLModifiedType)type).getWrappedType();
        }
        return type;
    }

    public static String formatExplainResult(ExecutionResult theResult) {
        Map aData = (Map)theResult.getData();
        StringBuilder sb = new StringBuilder();
        aData.forEach((key, value) -> sb.append(key.toUpperCase()).append(":").append(System.lineSeparator()).append(GraphQLUtil.formatValue(value)).append(System.lineSeparator()).append(System.lineSeparator()));
        return sb.toString();
    }

    private static String formatValue(Object obj) {
        if (obj instanceof Map) {
            return Joiner.on((String)System.lineSeparator()).withKeyValueSeparator(" -> ").join((Map)obj);
        }
        if (obj instanceof JSONObject) {
            Map<String, String> objMap;
            try {
                ObjectMapper mapper = new ObjectMapper();
                objMap = (Map)mapper.readValue(obj.toString(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            catch (IOException e) {
                objMap = new HashMap<String, String>();
                objMap.put("error", e.getMessage());
                objMap.put("plan", obj.toString());
            }
            return Joiner.on((String)System.lineSeparator()).withKeyValueSeparator(" -> ").join(objMap);
        }
        return obj.toString();
    }
}

