/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.graphql;

import com.complexible.common.base.ImmutableCollectors;
import com.complexible.common.base.Streams;
import com.complexible.stardog.graphql.StardogAliases;
import com.complexible.stardog.graphql.StardogDirectives;
import graphql.Directives;
import graphql.Scalars;
import graphql.i18n.I18n;
import graphql.introspection.Introspection;
import graphql.language.Argument;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.Node;
import graphql.language.SourceLocation;
import graphql.language.TypeDefinition;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.StaticDataFetcher;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.SchemaPrinter;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.validation.AbstractRule;
import graphql.validation.ArgumentValidationUtil;
import graphql.validation.DocumentVisitor;
import graphql.validation.LanguageTraversal;
import graphql.validation.RulesVisitor;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationError;
import graphql.validation.ValidationErrorClassification;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import graphql.validation.rules.FragmentsOnCompositeType;
import graphql.validation.rules.KnownDirectives;
import graphql.validation.rules.KnownFragmentNames;
import graphql.validation.rules.KnownTypeNames;
import graphql.validation.rules.LoneAnonymousOperation;
import graphql.validation.rules.NoFragmentCycles;
import graphql.validation.rules.NoUndefinedVariables;
import graphql.validation.rules.NoUnusedFragments;
import graphql.validation.rules.NoUnusedVariables;
import graphql.validation.rules.OverlappingFieldsCanBeMerged;
import graphql.validation.rules.PossibleFragmentSpreads;
import graphql.validation.rules.ProvidedNonNullArguments;
import graphql.validation.rules.VariableDefaultValuesOfCorrectType;
import graphql.validation.rules.VariableTypesMatch;
import graphql.validation.rules.VariablesAreInputTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.logging.log4j.util.Strings;

public class GraphQLSchemas {
    private static GraphQLObjectType DUMMY_TYPE = GraphQLObjectType.newObject().name("DUMMY").build();
    private static final Set<String> BUILTIN_DIRECTIVES = (Set)Streams.concat((Stream)StardogDirectives.ALL.stream(), Stream.of(StardogDirectives.SchemaDirectives.IRI, Directives.IncludeDirective, Directives.SkipDirective, Directives.DeprecatedDirective, Directives.DeferDirective, Directives.OneOfDirective, Directives.SpecifiedByDirective), (Stream[])new Stream[0]).map(GraphQLDirective::getName).collect(ImmutableCollectors.toSet());
    private static final String IRI_DIRECTIVE_DEFINITION = "directive @iri(namespace: String, prefix: String, value: String, localname: String) on FIELD_DEFINITION | OBJECT\n\n";
    private static final GraphQLDirective SCHEMA_SERIALIZATION = GraphQLDirective.newDirective().name("schemaSerialization").description("User-provided serialization of the schema.").validLocations(new Introspection.DirectiveLocation[]{Introspection.DirectiveLocation.SCHEMA}).build();

    public static GraphQLSchema read(String source) {
        SchemaParser schemaParser = new SchemaParser();
        SchemaGenerator schemaGenerator = new SchemaGenerator();
        Object augmentedSource = source.contains("directive @iri") ? source : IRI_DIRECTIVE_DEFINITION + source;
        TypeDefinitionRegistry typeRegistry = schemaParser.parse((String)augmentedSource);
        RuntimeWiring.Builder wiring = RuntimeWiring.newRuntimeWiring();
        for (TypeDefinition typeDef : typeRegistry.types().values()) {
            wiring.type(typeDef.getName(), typeWiring -> typeWiring.typeResolver(name -> DUMMY_TYPE).dataFetcher(typeDef.getName(), (DataFetcher)new StaticDataFetcher(new Object())));
        }
        SchemaGenerator.Options options = SchemaGenerator.Options.defaultOptions();
        GraphQLSchema schema = schemaGenerator.makeExecutableSchema(options, typeRegistry, wiring.build());
        return GraphQLSchema.newSchema((GraphQLSchema)schema).additionalDirectives(StardogDirectives.ALL).withSchemaDirective(GraphQLDirective.newDirective((GraphQLDirective)SCHEMA_SERIALIZATION).description(source).build()).build();
    }

    public static String write(GraphQLSchema schema) {
        GraphQLDirective directive = schema.getSchemaDirective(SCHEMA_SERIALIZATION.getName());
        if (directive != null && !Strings.isEmpty((CharSequence)directive.getDescription())) {
            return directive.getDescription();
        }
        SchemaPrinter.Options options = SchemaPrinter.Options.defaultOptions().includeDirectives(GraphQLSchemas::isUserDefinedDirective);
        SchemaPrinter printer = new SchemaPrinter(options);
        return printer.print(schema);
    }

    private static boolean isUserDefinedDirective(String directive) {
        return !BUILTIN_DIRECTIVES.contains(directive);
    }

    public static List<ValidationError> validate(GraphQLSchema schema, Document document) {
        I18n i18n = I18n.i18n((I18n.BundleType)I18n.BundleType.Validation, (Locale)Locale.US);
        ValidationContext validationContext = new ValidationContext(schema, document, i18n);
        ValidationErrorCollector validationErrorCollector = new ValidationErrorCollector();
        List<AbstractRule> rules = GraphQLSchemas.createRules(validationContext, validationErrorCollector);
        LanguageTraversal languageTraversal = new LanguageTraversal();
        languageTraversal.traverse((Node)document, (DocumentVisitor)new RulesVisitor(validationContext, rules));
        return validationErrorCollector.getErrors();
    }

    private static List<AbstractRule> createRules(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        ArrayList<AbstractRule> rules = new ArrayList<AbstractRule>();
        ArgumentsOfCorrectType argumentsOfCorrectType = new ArgumentsOfCorrectType(validationContext, validationErrorCollector);
        rules.add(argumentsOfCorrectType);
        FieldsOnCorrectType fieldsOnCorrectType = new FieldsOnCorrectType(validationContext, validationErrorCollector);
        rules.add(fieldsOnCorrectType);
        FragmentsOnCompositeType fragmentsOnCompositeType = new FragmentsOnCompositeType(validationContext, validationErrorCollector);
        rules.add((AbstractRule)fragmentsOnCompositeType);
        KnownArgumentNames knownArgumentNames = new KnownArgumentNames(validationContext, validationErrorCollector);
        rules.add(knownArgumentNames);
        KnownDirectives knownDirectives = new KnownDirectives(validationContext, validationErrorCollector);
        rules.add((AbstractRule)knownDirectives);
        KnownFragmentNames knownFragmentNames = new KnownFragmentNames(validationContext, validationErrorCollector);
        rules.add((AbstractRule)knownFragmentNames);
        KnownTypeNames knownTypeNames = new KnownTypeNames(validationContext, validationErrorCollector);
        rules.add((AbstractRule)knownTypeNames);
        NoFragmentCycles noFragmentCycles = new NoFragmentCycles(validationContext, validationErrorCollector);
        rules.add((AbstractRule)noFragmentCycles);
        NoUndefinedVariables noUndefinedVariables = new NoUndefinedVariables(validationContext, validationErrorCollector);
        rules.add((AbstractRule)noUndefinedVariables);
        NoUnusedFragments noUnusedFragments = new NoUnusedFragments(validationContext, validationErrorCollector);
        rules.add((AbstractRule)noUnusedFragments);
        NoUnusedVariables noUnusedVariables = new NoUnusedVariables(validationContext, validationErrorCollector);
        rules.add((AbstractRule)noUnusedVariables);
        OverlappingFieldsCanBeMerged overlappingFieldsCanBeMerged = new OverlappingFieldsCanBeMerged(validationContext, validationErrorCollector);
        rules.add((AbstractRule)overlappingFieldsCanBeMerged);
        PossibleFragmentSpreads possibleFragmentSpreads = new PossibleFragmentSpreads(validationContext, validationErrorCollector);
        rules.add((AbstractRule)possibleFragmentSpreads);
        ProvidedNonNullArguments providedNonNullArguments = new ProvidedNonNullArguments(validationContext, validationErrorCollector);
        rules.add((AbstractRule)providedNonNullArguments);
        VariableDefaultValuesOfCorrectType variableDefaultValuesOfCorrectType = new VariableDefaultValuesOfCorrectType(validationContext, validationErrorCollector);
        rules.add((AbstractRule)variableDefaultValuesOfCorrectType);
        VariablesAreInputTypes variablesAreInputTypes = new VariablesAreInputTypes(validationContext, validationErrorCollector);
        rules.add((AbstractRule)variablesAreInputTypes);
        VariableTypesMatch variableTypesMatchRule = new VariableTypesMatch(validationContext, validationErrorCollector);
        rules.add((AbstractRule)variableTypesMatchRule);
        LoneAnonymousOperation loneAnonymousOperation = new LoneAnonymousOperation(validationContext, validationErrorCollector);
        rules.add((AbstractRule)loneAnonymousOperation);
        return rules;
    }

    private static ValidationError.Builder newValidationError(ValidationErrorType type, SourceLocation location, String message) {
        return new ValidationError.Builder().validationErrorType((ValidationErrorClassification)type).sourceLocation(location).description(message);
    }

    private static class ArgumentsOfCorrectType
    extends AbstractRule {
        public ArgumentsOfCorrectType(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
            super(validationContext, validationErrorCollector);
        }

        public void checkArgument(Argument argument) {
            GraphQLArgument fieldArgument = this.getValidationContext().getArgument();
            if (fieldArgument == null) {
                return;
            }
            ArgumentValidationUtil validationUtil = new ArgumentValidationUtil(argument);
            if (!validationUtil.isValidLiteralValue(argument.getValue(), (GraphQLType)fieldArgument.getType(), this.getValidationContext().getSchema(), this.getValidationContext().getGraphQLContext(), this.getValidationContext().getI18n().getLocale())) {
                GraphQLDirective directive = this.getValidationContext().getDirective();
                if (directive != null) {
                    if ((directive.equals((Object)Directives.IncludeDirective) || directive.equals((Object)Directives.SkipDirective) || directive.equals((Object)StardogDirectives.FILTER)) && validationUtil.isValidLiteralValue(argument.getValue(), (GraphQLType)Scalars.GraphQLString, this.getValidationContext().getSchema(), this.getValidationContext().getGraphQLContext(), this.getValidationContext().getI18n().getLocale())) {
                        return;
                    }
                    if (directive.equals((Object)StardogDirectives.CONFIG)) {
                        return;
                    }
                }
                GraphQLCompositeType parentType = this.getValidationContext().getParentType();
                if (argument.getName().equals("orderBy") || argument.getName().equals("iri")) {
                    return;
                }
                this.addError(GraphQLSchemas.newValidationError(ValidationErrorType.WrongType, argument.getSourceLocation(), validationUtil.getMsgAndArgs().toI18n(this.getValidationContext().getI18n())));
            }
        }
    }

    private static class FieldsOnCorrectType
    extends AbstractRule {
        public FieldsOnCorrectType(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
            super(validationContext, validationErrorCollector);
        }

        public void checkField(Field field) {
            GraphQLCompositeType parentType = this.getValidationContext().getParentType();
            if (parentType == null) {
                return;
            }
            GraphQLFieldDefinition fieldDef = this.getValidationContext().getFieldDef();
            if (fieldDef == null) {
                Set fieldDirectives = field.getDirectivesByName().keySet();
                if (fieldDirectives.contains(StardogDirectives.BIND.getName()) || fieldDirectives.contains(StardogDirectives.PREFIX.getName())) {
                    return;
                }
                if (fieldDirectives.contains(StardogDirectives.TYPE.getName())) {
                    if (this.getValidationContext().getSchema().getType(field.getName()) == null) {
                        String message = String.format("Field '%s' in type '%s' is used with @type directive but not a defined type", field.getName(), parentType.getName());
                        this.addError(GraphQLSchemas.newValidationError(ValidationErrorType.FieldUndefined, field.getSourceLocation(), message));
                    }
                    return;
                }
                String message = String.format("Field '%s' in type '%s' is undefined", field.getName(), parentType.getName());
                this.addError(GraphQLSchemas.newValidationError(ValidationErrorType.FieldUndefined, field.getSourceLocation(), message));
            }
        }
    }

    private static class KnownArgumentNames
    extends AbstractRule {
        public KnownArgumentNames(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
            super(validationContext, validationErrorCollector);
        }

        public void checkArgument(Argument argument) {
            GraphQLDirective directiveDef = this.getValidationContext().getDirective();
            if (directiveDef != null) {
                if (directiveDef.equals((Object)StardogDirectives.PREFIX)) {
                    return;
                }
                GraphQLArgument directiveArgument = directiveDef.getArgument(argument.getName());
                if (directiveArgument == null) {
                    String message = String.format("Unknown directive argument %s", argument.getName());
                    this.addError(GraphQLSchemas.newValidationError(ValidationErrorType.UnknownDirective, argument.getSourceLocation(), message));
                }
                return;
            }
            if (StardogAliases.ALL.containsKey((Object)argument.getName())) {
                return;
            }
            GraphQLFieldDefinition fieldDef = this.getValidationContext().getFieldDef();
            if (fieldDef == null) {
                return;
            }
            GraphQLArgument fieldArgument = fieldDef.getArgument(argument.getName());
            if (fieldArgument == null) {
                String message = String.format("Unknown field argument %s", argument.getName());
                this.addError(GraphQLSchemas.newValidationError(ValidationErrorType.UnknownArgument, argument.getSourceLocation(), message));
            }
        }
    }
}

