/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.graphql;

import com.complexible.stardog.db.DatabaseOptions;
import com.complexible.stardog.metadata.ConfigProperty;
import com.complexible.stardog.metadata.MetaProperty;
import com.complexible.stardog.metadata.MetaPropertyProvider;
import com.complexible.stardog.metadata.OptionsCategory;
import com.complexible.stardog.metadata.TextIO;
import com.google.common.collect.ImmutableSet;
import com.stardog.model.DataModelFormat;
import com.stardog.stark.IRI;
import com.stardog.stark.Values;
import java.util.Collection;

public final class GraphQLOptions
implements MetaPropertyProvider {
    public static final ConfigProperty<Long> DEFAULT_LIMIT = (ConfigProperty)MetaProperty.config((String)"graphql.default.limit", (Object)-1L).database().readable().writableWhileOnline().creatable().category(OptionsCategory.GRAPHQL).label("Default Limit").description("The maximum number of top-level objects a GraphQL query can return. The argument \"first\" can be used within queries to limit results as well.").build();
    public static final ConfigProperty<String> RESULT_MEMORY_LIMIT = (ConfigProperty)MetaProperty.config((String)"graphql.result.memory.limit", (Object)"100M").database().readable().writableWhileOnline().creatable().category(OptionsCategory.GRAPHQL).label("Result Memory Limit").description("The maximum number of heap memory a GraphQL result can use. GraphQL query results are created fully in memory before they are sent back to the client. This limit ensures query results will not use too much memory causing server to run out of memory. GraphQL queries are translated to SPARQL queries and the amount of memory the SPARQL query will use during execution is controlled by the " + String.valueOf(DatabaseOptions.QUERY_MEMORY_LIMIT) + " option.").build();
    public static final ConfigProperty<Boolean> AUTO_SCHEMA = (ConfigProperty)MetaProperty.config((String)"graphql.auto.schema", (Object)false).database().readable().writableWhileOnline().creatable().category(OptionsCategory.GRAPHQL).label("Auto Schema").description("Enables automatic generation of the default GraphQL schema if one has not been created by the user.").build();
    public static final ConfigProperty<DataModelFormat> AUTO_SCHEMA_SOURCE = (ConfigProperty)MetaProperty.config((String)"graphql.auto.schema.source", (Object)DataModelFormat.OWL).database().readable().writableWhileOnline().creatable().category(OptionsCategory.GRAPHQL).label("Auto Schema Source").description("Specifies the input source to use for generating the default GraphQL schema automatically.").possibleValues((Collection)DataModelFormat.INPUTS).build();
    public static final ConfigProperty<Collection<IRI>> DATA_GRAPHS = (ConfigProperty)MetaProperty.config((String)"graphql.data.graphs", IRI.class, (Collection)ImmutableSet.of((Object)Values.LOCAL_GRAPHS)).textIO(TextIO.forSet(IRI.class, (TextIO)TextIO.URI_IO_WILDCARD_ALL)).database().readable().writableWhileOnline().creatable().category(OptionsCategory.GRAPHQL).label("Data Graphs").description("Specifies which graphs will be queried by default via GraphQL queries. The default value (tag:stardog:api:context:local) is to query all local graphs (default or named). Use the special graph tag:stardog:api:context:all to query all local graphs plus the virtual graphs. Multiple graphs or graph aliases can be used as the option value.").build();
}

