/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io.jsonld;

import com.complexible.common.base.Options;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.stardog.stark.Datatype;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFWriter;
import com.stardog.stark.io.RDFWriterFactory;
import com.stardog.stark.io.WriterOptions;
import com.stardog.stark.io.WritingFailed;
import com.stardog.stark.io.jsonld.JSONLDOptions;
import com.stardog.stark.io.jsonld.JsonUtils;
import com.stardog.stark.vocabs.RDF;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class StreamingJSONLDWriter
implements RDFWriter {
    protected final JsonGenerator mWriter;
    protected final Options mOptions;
    protected final Map<String, String> mNamespaces = Maps.newHashMap();
    protected boolean mStarted = false;
    protected boolean mNamespacesWritten = false;
    protected Resource currentSubject = null;
    protected Multimap<IRI, Value> currentTriples = HashMultimap.create();
    private Resource currentContext;
    private final boolean useNativeTypes;
    private final boolean useRDFType;
    private final int maxBufferSize;
    private static final Pattern PATTERN_INTEGER = Pattern.compile("^[\\-+]?[0-9]+$");
    private static final Pattern PATTERN_DOUBLE = Pattern.compile("^(\\+|-)?([0-9]+(\\.[0-9]*)?|\\.[0-9]+)([Ee](\\+|-)?[0-9]+)?$");

    public StreamingJSONLDWriter(OutputStream theWriter, Options theOptions) {
        try {
            this.mWriter = JsonUtils.createGenerator(new OutputStreamWriter(theWriter, this.format().charset()));
            this.mOptions = theOptions;
            this.useNativeTypes = this.mOptions.is(JSONLDOptions.USE_NATIVE_TYPES);
            this.useRDFType = this.mOptions.is(JSONLDOptions.USE_RDF_TYPE);
            this.maxBufferSize = (Integer)this.mOptions.get(WriterOptions.BUFFER_SIZE);
            boolean isPrettyPrint = theOptions.is(WriterOptions.PRETTY_PRINT);
            if (isPrettyPrint) {
                this.mWriter.useDefaultPrettyPrinter();
            }
            if (theOptions.contains(WriterOptions.NAMESPACES)) {
                ((Iterable)this.mOptions.get(WriterOptions.NAMESPACES)).forEach(ns -> this.mNamespaces.put(ns.iri(), ns.prefix()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void start() {
        if (this.mStarted) {
            return;
        }
        this.mStarted = true;
        this.mNamespacesWritten = false;
        this.currentContext = Values.DEFAULT_GRAPH;
        this.currentSubject = null;
        this.currentTriples.clear();
    }

    private void writePreamble(boolean writeNamespaces) throws IOException {
        if (this.mNamespacesWritten) {
            return;
        }
        this.mNamespacesWritten = true;
        this.mWriter.writeStartObject();
        if (writeNamespaces && this.mNamespaces.size() > 0) {
            this.mWriter.writeFieldName("@context");
            this.mWriter.writeStartObject();
            for (Map.Entry<String, String> entry : this.mNamespaces.entrySet()) {
                String name = entry.getKey();
                String prefix = entry.getValue();
                if (prefix.equals("")) {
                    prefix = "@vocab";
                }
                this.mWriter.writeStringField(prefix, name);
            }
            this.mWriter.writeEndObject();
        }
        this.mWriter.writeFieldName("@graph");
        this.mWriter.writeStartArray();
    }

    public void end() {
        if (!this.mStarted) {
            return;
        }
        try {
            this.writePreamble(false);
            this.closePreviousStatement();
            this.closeActiveContext();
            this.mWriter.writeEndArray();
            this.mWriter.writeEndObject();
            this.mWriter.flush();
        }
        catch (IOException e) {
            throw new WritingFailed((Throwable)e);
        }
        finally {
            this.mStarted = false;
        }
    }

    protected void startActiveContext(Resource context) throws IOException {
        if (!Values.isDefaultGraph((Resource)context)) {
            this.mWriter.writeStartObject();
            this.writeID(context);
            this.mWriter.writeFieldName("@graph");
            this.mWriter.writeStartArray();
        }
        this.currentContext = context;
    }

    protected void closeActiveContext() throws IOException {
        if (!Values.isDefaultGraph((Resource)this.currentContext)) {
            this.mWriter.writeEndArray();
            this.mWriter.writeEndObject();
        }
        this.currentContext = Values.DEFAULT_GRAPH;
    }

    public void comment(@Nonnull String theComment) {
    }

    public void handle(@Nonnull Statement theStmt) {
        try {
            this.writePreamble(true);
            Resource context = theStmt.context();
            if (!Objects.equals(context, this.currentContext)) {
                this.closePreviousStatement();
                this.closeActiveContext();
                this.startActiveContext(context);
            }
            Resource subj = theStmt.subject();
            IRI pred = theStmt.predicate();
            Value obj = theStmt.object();
            if (!subj.equals((Object)this.currentSubject) || this.currentTriples.size() >= this.maxBufferSize) {
                this.closePreviousStatement();
                this.currentSubject = subj;
            }
            this.currentTriples.put((Object)pred, (Object)obj);
        }
        catch (IOException e) {
            throw new WritingFailed((Throwable)e);
        }
    }

    public void namespace(@Nonnull String thePrefix, @Nonnull String theIRI) {
        if (this.mNamespacesWritten) {
            return;
        }
        if (!this.mNamespaces.containsKey(theIRI) && !this.mNamespaces.containsValue(thePrefix)) {
            this.mNamespaces.put(theIRI, thePrefix);
        }
    }

    protected void closePreviousStatement() {
        try {
            if (this.currentSubject != null) {
                Object types;
                this.mWriter.writeStartObject();
                this.writeID(this.currentSubject);
                if (!this.useRDFType && !(types = this.currentTriples.removeAll((Object)RDF.TYPE)).isEmpty()) {
                    if (Iterables.all((Iterable)types, Resource.class::isInstance)) {
                        this.writeTypes((Collection<Value>)types);
                    } else {
                        this.writePredicateValues(RDF.TYPE, (Collection<Value>)types);
                    }
                }
                for (Map.Entry entry : this.currentTriples.asMap().entrySet()) {
                    this.writePredicateValues((IRI)entry.getKey(), (Collection)entry.getValue());
                }
                this.mWriter.writeEndObject();
                this.currentTriples.clear();
                this.currentSubject = null;
            }
        }
        catch (IOException e) {
            throw new WritingFailed("Unable to close statement", (Throwable)e);
        }
    }

    private void writeID(Resource resource) throws IOException {
        if (resource instanceof Statement) {
            Statement stmt = (Statement)resource;
            this.mWriter.writeFieldName("@id");
            this.mWriter.writeStartObject();
            this.writeID(stmt.subject());
            this.writePredicateValues(stmt.predicate(), Collections.singleton(stmt.object()));
            this.mWriter.writeEndObject();
        } else {
            this.writeResourceField("@id", resource);
        }
    }

    private void writeResourceField(String field, Resource resource) throws IOException {
        this.mWriter.writeStringField(field, this.formatResource(resource));
    }

    protected void writeTypes(Collection<Value> types) throws IOException {
        this.writePredicateValues("@type", types, true);
    }

    protected void writePredicateValues(IRI predicate, Collection<Value> values) throws IOException {
        this.writePredicateValues(this.formatIRI(predicate), values, false);
    }

    protected void writePredicateValues(String predicate, Collection<Value> values, boolean onlyResources) throws IOException {
        boolean isArray;
        this.mWriter.writeFieldName(predicate);
        boolean bl = isArray = values.size() > 1;
        if (isArray) {
            this.mWriter.writeStartArray();
        }
        if (onlyResources) {
            for (Value value : values) {
                this.mWriter.writeString(this.formatResource((Resource)value));
            }
        } else {
            for (Value value : values) {
                this.writeValue(value);
            }
        }
        if (isArray) {
            this.mWriter.writeEndArray();
        }
    }

    protected void writeValue(@Nonnull Value theValue) throws IOException {
        this.mWriter.writeStartObject();
        if (theValue instanceof Resource) {
            this.writeID((Resource)theValue);
        } else {
            this.writeLiteral((Literal)theValue);
        }
        this.mWriter.writeEndObject();
    }

    protected String formatResource(Resource res) {
        if (res instanceof IRI) {
            return this.formatIRI((IRI)res);
        }
        if (res instanceof Statement) {
            throw new UnsupportedOperationException();
        }
        return res.toString();
    }

    protected String formatIRI(IRI iri) {
        String ns = iri.namespace();
        String localName = iri.localName();
        String prefix = this.mNamespaces.get(ns);
        if (prefix != null && !localName.isEmpty()) {
            return prefix.isEmpty() ? localName : prefix + ":" + localName;
        }
        return iri.toString();
    }

    protected void writeLiteral(@Nonnull Literal literal) throws IOException {
        this.mWriter.writeFieldName("@value");
        String value = literal.label();
        boolean isLang = literal.lang().isPresent();
        if (!isLang) {
            Datatype datatype = literal.datatype();
            boolean nativeTypeUsed = false;
            if (datatype.equals((Object)Datatype.STRING)) {
                this.mWriter.writeString(value);
                return;
            }
            if (this.useNativeTypes) {
                if (datatype.equals((Object)Datatype.BOOLEAN)) {
                    if ("true".equals(value)) {
                        this.mWriter.writeBoolean(true);
                        return;
                    }
                    if ("false".equals(value)) {
                        this.mWriter.writeBoolean(false);
                        return;
                    }
                } else {
                    if (Datatype.INTEGER.equals((Object)datatype) && PATTERN_INTEGER.matcher(value).matches()) {
                        this.mWriter.writeNumber(value);
                        return;
                    }
                    if (Datatype.DOUBLE.equals((Object)datatype) && PATTERN_DOUBLE.matcher(value).matches()) {
                        this.mWriter.writeNumber(value);
                        return;
                    }
                }
            }
        }
        this.mWriter.writeString(value);
        if (isLang) {
            this.mWriter.writeStringField("@language", (String)literal.lang().get());
        } else {
            this.writeResourceField("@type", (Resource)literal.datatypeIRI());
        }
    }

    @Nonnull
    public RDFFormat format() {
        return RDFFormats.JSONLD;
    }

    public static final class StreamingJSONLDWriterFactory
    implements RDFWriterFactory {
        @Nonnull
        public RDFFormat format() {
            return RDFFormats.JSONLD;
        }

        @Nonnull
        public RDFWriter create(@Nonnull OutputStream theStream, @Nonnull Options theOptions) {
            return new StreamingJSONLDWriter(theStream, theOptions);
        }
    }
}

