/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.pack.replication.impl.zookeeper;

import com.complexible.common.util.EnhancedProperties;
import com.google.common.base.Charsets;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZKUtils.class);
    private static final String newLine = System.lineSeparator();

    public static String getZkConnString(EnhancedProperties configuration) {
        return configuration.select(theStr -> theStr.startsWith("pack.zookeeper")).transformKeys(theStr -> theStr.substring("pack.zookeeper.".length())).getProperty("address");
    }

    public static Closeable watchPath(CuratorFramework curator, String path, BiConsumer<String, byte[]> addedHandler, Consumer<String> removedHandler) throws Exception {
        return ZKUtils.watchPath(curator, path, addedHandler, null, removedHandler);
    }

    public static Closeable watchPath(CuratorFramework curator, String path, BiConsumer<String, byte[]> addedHandler, BiConsumer<String, byte[]> updatedHandler, Consumer<String> removedHandler) throws Exception {
        PathChildrenCache cache = new PathChildrenCache(curator, path, true);
        cache.getListenable().addListener((client, event) -> {
            switch (event.getType()) {
                case CHILD_ADDED: {
                    addedHandler.accept(event.getData().getPath(), event.getData().getData());
                    break;
                }
                case CHILD_REMOVED: {
                    removedHandler.accept(event.getData().getPath());
                    break;
                }
                case CHILD_UPDATED: {
                    if (updatedHandler == null) {
                        throw new IllegalArgumentException();
                    }
                    updatedHandler.accept(event.getData().getPath(), event.getData().getData());
                }
            }
        });
        cache.start();
        return cache;
    }

    public static void visitKids(CuratorFramework curator, String path, BiConsumer<String, byte[]> addedOrUpdateHandler) throws Exception {
        List children = (List)curator.getChildren().forPath(path);
        for (String child : children) {
            String zkNodePath = path + "/" + child;
            addedOrUpdateHandler.accept(zkNodePath, (byte[])curator.getData().forPath(zkNodePath));
        }
    }

    public static String getTree(CuratorFramework framework, String path, String name, String indent) throws Exception {
        Object zkTree = ZKUtils.getNode(framework, path, name, (String)indent);
        indent = (String)indent + "  ";
        for (String child : (List)framework.getChildren().forPath(path)) {
            zkTree = (String)zkTree + ZKUtils.getTree(framework, path + "/" + child, child, (String)indent);
        }
        return zkTree;
    }

    private static String getNode(CuratorFramework framework, String path, String name, String indent) throws Exception {
        long owner;
        String zkNode = indent + name + newLine;
        Stat stat = new Stat();
        byte[] data = (byte[])((WatchPathable)framework.getData().storingStatIn(stat)).forPath(path);
        if (data != null && data.length != 0) {
            zkNode = zkNode + " - " + new String(data, Charsets.UTF_8) + newLine;
        }
        if ((owner = stat.getEphemeralOwner()) != 0L) {
            zkNode = zkNode + " (owner: " + owner + ")" + newLine;
        }
        return zkNode;
    }

    public static void setACLsForZnodeAndChildren(CuratorFramework framework, String znodePath, List<ACL> acls) {
        try {
            LOGGER.debug("Applying ACLs {} to znode {}", acls, (Object)znodePath);
            ((BackgroundPathable)framework.setACL().withACL(acls)).forPath(znodePath);
            List children = (List)framework.getChildren().forPath(znodePath);
            for (String child : children) {
                String zchildPath = znodePath + "/" + child;
                ZKUtils.setACLsForZnodeAndChildren(framework, zchildPath, acls);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to apply ACLs to znode {} and its children", (Object)znodePath, (Object)e);
        }
    }

    public static List<ACL> getZnodeACLs(CuratorFramework framework, String znodePath) {
        ArrayList<ACL> acls = new ArrayList<ACL>();
        try {
            acls.addAll((Collection)framework.getACL().forPath(znodePath));
        }
        catch (Exception e) {
            LOGGER.error("Failed to get ZooKeeper ACLs for znode: {}", (Object)znodePath, (Object)e);
        }
        LOGGER.debug("Obtained ACLs {} from ZK path {}", acls, (Object)znodePath);
        return acls;
    }
}

