/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.pack.replication.impl.zookeeper;

import com.complexible.common.base.Duration;
import com.complexible.common.base.OptionFunction;
import com.complexible.common.base.Options;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.pack.replication.ClusterOptions;
import com.complexible.stardog.pack.replication.impl.zookeeper.CuratorFactory;
import com.complexible.stardog.pack.replication.impl.zookeeper.ZKUtils;
import com.complexible.stardog.pack.replication.impl.zookeeper.ZkACLProvider;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.io.Closeables;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.retry.RetryNTimes;
import org.apache.curator.utils.ZookeeperFactory;
import org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfiguredCuratorFactory
implements CuratorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(CuratorFactory.class);

    @Override
    public CuratorFramework newCurator(String theZKConnString, Options theZKClusterOptions) throws StardogException {
        LOGGER.debug("Initializing ZooKeeper instance");
        if (Strings.isNullOrEmpty((String)theZKConnString)) {
            throw new StardogException("Can't initialize Stardog Cluster: `pack.zookeeper.address` setting is required in stardog.properties file.");
        }
        String aZKAuthString = (String)theZKClusterOptions.get(ClusterOptions.ZOOKEEPER_AUTH_STRING);
        if (Strings.isNullOrEmpty((String)aZKAuthString)) {
            throw new StardogException("Can't initialize Stardog Cluster: `pack.zookeeper.auth` setting username:password is required in stardog.properties file.");
        }
        ArrayList<ACL> acls = new ArrayList<ACL>();
        String znodePath = (String)theZKClusterOptions.get(ClusterOptions.ZK_INHERIT_ACL_PATH);
        if (znodePath != null) {
            if (!znodePath.startsWith("/")) {
                LOGGER.warn("Option {} must start with / ACLs from znode {} will not be applied to Stardog znodes.", (Object)ClusterOptions.ZK_INHERIT_ACL_PATH.getName(), (Object)znodePath);
            } else if (znodePath.length() > 1 && znodePath.endsWith("/")) {
                LOGGER.warn("Option {} cannot end with a / (except when root is specified) ACLs from znode {} will not be applied to Stardog znodes.", (Object)ClusterOptions.ZK_INHERIT_ACL_PATH.getName(), (Object)znodePath);
            } else {
                LOGGER.info("Using ZK path for inherited ACLs: {}", (Object)znodePath);
                CuratorFramework origCurator = this.getInitializedCurator(theZKConnString, theZKClusterOptions, aZKAuthString, Collections.emptyList());
                acls.addAll(ZKUtils.getZnodeACLs(origCurator, znodePath));
                acls.add(ZkACLProvider.defaultACL);
                ZKUtils.setACLsForZnodeAndChildren(origCurator, "/stardog", acls);
                origCurator.close();
            }
        } else {
            LOGGER.debug("Option to inherit ACLs from a specific znode is not specified, skipping");
        }
        return this.getInitializedCurator(theZKConnString, theZKClusterOptions, aZKAuthString, acls);
    }

    private CuratorFramework getInitializedCurator(String theZKConnString, Options theZKClusterOptions, String theZKAuthString, List<ACL> theACLs) throws StardogException {
        CuratorFramework aFramework = null;
        try {
            int aConnTimeout = Ints.checkedCast((long)((Duration)theZKClusterOptions.get(ClusterOptions.CONNECTION_TIMEOUT)).getMillis());
            int aSessionTimeout = Ints.checkedCast((long)((Duration)theZKClusterOptions.get(ClusterOptions.SESSION_TIMEOUT)).getMillis());
            int aCuratorRetryCount = Ints.checkedCast((long)((Integer)theZKClusterOptions.get(ClusterOptions.CURATOR_RETRY_COUNT)).intValue());
            int aCuratorRetryDelayMs = Ints.checkedCast((long)((Duration)theZKClusterOptions.get(ClusterOptions.CURATOR_RETRY_DELAY)).getMillis());
            boolean aEnsembleTracker = (Boolean)theZKClusterOptions.get(ClusterOptions.CURATOR_ENSEMBLE_TRACKER);
            ZookeeperFactory zkFactory = (ZookeeperFactory)theZKClusterOptions.get(ClusterOptions.ZOOKEEPER_FACTORY);
            aFramework = this.build(CuratorFrameworkFactory.builder().connectString(theZKConnString).defaultData(null).connectionTimeoutMs(aConnTimeout).sessionTimeoutMs(aSessionTimeout).retryPolicy((RetryPolicy)new RetryNTimes(aCuratorRetryCount, aCuratorRetryDelayMs)).aclProvider((ACLProvider)new ZkACLProvider(theACLs)).zookeeperFactory(zkFactory).ensembleTracker(aEnsembleTracker).authorization("digest", theZKAuthString.getBytes()), theZKClusterOptions);
            aFramework.start();
            aFramework.getZookeeperClient().blockUntilConnectedOrTimedOut();
            if (aFramework.getState() != CuratorFrameworkState.STARTED) {
                throw new StardogException("Couldn't connect to ZooKeeper: ZK startup timed out");
            }
            int actualSessionTimeout = aFramework.getZookeeperClient().getZooKeeper().getSessionTimeout();
            if (actualSessionTimeout != aSessionTimeout) {
                LOGGER.warn("Session timeout for ZooKeeper client has been overriden by the ZooKeeper Server. Expected: {}, actual {}. Increase the tick time on the ZooKeeper server if this is not acceptable", (Object)aSessionTimeout, (Object)actualSessionTimeout);
            }
            return aFramework;
        }
        catch (Throwable t) {
            LOGGER.error("Unable to initialize ZooKeeper", t);
            if (aFramework != null) {
                try {
                    Closeables.close(aFramework, (boolean)true);
                }
                catch (IOException theE) {
                    throw new AssertionError((Object)theE);
                }
            }
            Throwables.throwIfInstanceOf((Throwable)t, StardogException.class);
            throw new StardogException(t);
        }
    }

    @Override
    public CuratorFramework newCurator(OptionFunction config) throws StardogException {
        Options aClusterOptions = ClusterOptions.defaults();
        aClusterOptions.set(ClusterOptions.SESSION_TIMEOUT, (Object)((Duration)config.get(ClusterOptions.SESSION_TIMEOUT)));
        aClusterOptions.set(ClusterOptions.CONNECTION_TIMEOUT, (Object)((Duration)config.get(ClusterOptions.CONNECTION_TIMEOUT)));
        aClusterOptions.set(ClusterOptions.ZOOKEEPER_AUTH_STRING, (Object)((String)config.get(ClusterOptions.ZOOKEEPER_AUTH_STRING)));
        aClusterOptions.set(ClusterOptions.CURATOR_RETRY_COUNT, (Object)((Integer)config.get(ClusterOptions.CURATOR_RETRY_COUNT)));
        aClusterOptions.set(ClusterOptions.CURATOR_RETRY_DELAY, (Object)((Duration)config.get(ClusterOptions.CURATOR_RETRY_DELAY)));
        return this.newCurator((String)config.get(ClusterOptions.ZOOKEEPER_CONN_STRING), aClusterOptions);
    }

    protected CuratorFramework build(CuratorFrameworkFactory.Builder presetBuilder, Options extraOptions) {
        return presetBuilder.build();
    }
}

