/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.pack.replication;

import com.complexible.common.base.Duration;
import com.complexible.common.base.Option;
import com.complexible.common.base.Options;
import com.complexible.stardog.pack.replication.impl.TxAction;
import com.complexible.stardog.pack.replication.util.LockType;
import com.google.common.collect.ImmutableMap;
import java.util.concurrent.TimeUnit;
import org.apache.curator.utils.DefaultZookeeperFactory;
import org.apache.curator.utils.ZookeeperFactory;

public final class ClusterOptions {
    public static final Duration TX_LONG_TIMEOUT = new Duration(1L, TimeUnit.HOURS);
    public static final Duration TX_MID_TIMEOUT = new Duration(30L, TimeUnit.MINUTES);
    public static final Duration TX_SHORT_TIMEOUT = new Duration(10L, TimeUnit.MINUTES);
    public static final Duration TX_VERY_SHORT_TIMEOUT = new Duration(5L, TimeUnit.MINUTES);
    public static final Duration DEFAULT_TIMEOUT = new Duration(30L, TimeUnit.MINUTES);
    public static final Option<Boolean> FALLBACK_TO_FULL_SYNC = Option.create((String)"pack.fallback.fullsync", (Object)true);
    public static final Option<ImmutableMap<TxAction, Duration>> TX_TIMEOUTS = Option.create((String)"tx_timeouts", (Object)ImmutableMap.builder().put((Object)TxAction.BEGIN, (Object)TX_SHORT_TIMEOUT).put((Object)TxAction.PREPARE, (Object)TX_LONG_TIMEOUT).put((Object)TxAction.COMMIT, (Object)TX_LONG_TIMEOUT).put((Object)TxAction.REPLICATE, (Object)TX_LONG_TIMEOUT).put((Object)TxAction.ROLLBACK, (Object)TX_MID_TIMEOUT).build());
    public static final Option<ImmutableMap<LockType, Duration>> LOCK_TIMEOUTS = Option.create((String)"locks_timeouts", (Object)ImmutableMap.builder().put((Object)LockType.JOIN, (Object)TX_VERY_SHORT_TIMEOUT).put((Object)LockType.WRITE, (Object)DEFAULT_TIMEOUT).put((Object)LockType.ADMIN, (Object)TX_SHORT_TIMEOUT).build());
    public static final Option<Integer> PREPARE_TIMEOUT_COEFFICIENT = Option.create((String)"pack.coefficient.timeouts.tx.prepare", (Object)3);
    public static final Option<Duration> SESSION_TIMEOUT = Option.create((String)"pack.session.timeout", (Object)new Duration((long)Integer.getInteger("curator-default-session-timeout", 60000).intValue()));
    public static final Option<Integer> CURATOR_RETRY_COUNT = Option.create((String)"pack.curator.retry.count", (Object)3);
    public static final Option<Duration> CURATOR_RETRY_DELAY = Option.create((String)"pack.curator.retry.delay", (Object)new Duration(5L, TimeUnit.SECONDS));
    public static final Option<ZookeeperFactory> ZOOKEEPER_FACTORY = Option.create((String)"pack.curator.zookeeperFactory", (Object)new DefaultZookeeperFactory());
    public static final Option<Integer> NODE_JOIN_RETRY_COUNT = Option.create((String)"pack.node.join.retry.count", (Object)20);
    public static final Option<Duration> NODE_JOIN_RETRY_DELAY = Option.create((String)"pack.node.join.retry.delay", (Object)new Duration(5L, TimeUnit.SECONDS));
    public static final Option<Duration> CONNECTION_TIMEOUT = Option.create((String)"pack.connection.timeout", (Object)new Duration((long)Integer.getInteger("curator-default-connection-timeout", 15000).intValue()));
    public static final Option<String> ZOOKEEPER_AUTH_STRING = Option.create((String)"pack.zookeeper.auth", (Object)"admin:admin");
    public static final Option<String> ZOOKEEPER_CONN_STRING = Option.create((String)"pack.zookeeper.address");
    public static final Option<Integer> RETRY_COUNT = Option.create((String)"pack.retry.count", (Object)3);
    public static final Option<Duration> RETRY_DELAY = Option.create((String)"pack.retry.delay", (Object)new Duration(10L, TimeUnit.SECONDS));
    public static final Option<Integer> JOIN_RETRY_COUNT = Option.create((String)"pack.join.retry.count", (Object)3);
    public static final Option<Integer> JOIN_LOCK_THRESHOLD_START = Option.create((String)"pack.join.lock.threshold.start", (Object)1);
    public static final Option<Integer> JOIN_LOCK_THRESHOLD_END = Option.create((String)"pack.join.lock.threshold.end", (Object)10);
    public static final Option<String> JOIN_STRATEGY_NAME = Option.create((String)"pack.join.strategy", (Object)"UNDER_LOCK_AFTER_N");
    public static final Option<Boolean> STANDBY = Option.create((String)"pack.standby", (Object)false);
    public static final Option<Duration> STANDBY_NODE_SYNC_INTERVAL = Option.create((String)"pack.standby.node.sync.interval", (Object)new Duration(5L, TimeUnit.MINUTES));
    public static final Option<Boolean> READ_REPLICA = Option.create((String)"pack.readReplica", (Object)false);
    public static final Option<Boolean> GEO_REPLICA = Option.create((String)"pack.geoReplica", (Object)false);
    public static final Option<String> GEO_REPLICA_CLUSTER_ADDRESS = Option.create((String)"pack.geoReplica.address", (Object)"localhost:5820");
    public static final Option<String> GEO_REPLICA_CLUSTER_USER = Option.create((String)"pack.geoReplica.connection.user", (Object)"zkadmin");
    public static final Option<String> GEO_REPLICA_CLUSTER_PASSWORD = Option.create((String)"pack.geoReplica.connection.password", (Object)"password");
    public static final Option<String> SYNC_STRATEGY_NAME = Option.create((String)"pack.sync.strategy", (Object)"ROUND_ROBIN");
    public static final Option<Boolean> SHUTDOWN_ON_EVICTION = Option.create((String)"pack.rejoin.shutdown", (Object)true);
    public static final Option<String> BACKUP_REPLICATION_SCHEME = Option.create((String)"pack.backups.replicated.scheme", (Object)"file");
    public static final Option<String> KRB5_CLUSTER_PEER_PRINCIPAL = Option.create((String)"pack.krb5.principal", null);
    public static final Option<String> PEER_KEYTAB = Option.create((String)"pack.krb5.keytab", null);
    public static final Option<Boolean> CURATOR_ENSEMBLE_TRACKER = Option.create((String)"pack.zookeeper.ensembleTracker", (Object)true);
    public static final Option<Boolean> ZK_CLUSTER_CACHED_MEMBERS = Option.create((String)"pack.zookeeper.cachedMembers", (Object)false);
    public static final Option<Boolean> ZK_CLUSTER_INACTIVE_ON_SUSPEND = Option.create((String)"pack.zookeeper.inactiveOnSuspend", (Object)true);
    public static final Option<Boolean> PROCESS_CANCEL_ENABLED = Option.create((String)"pack.process.cancel.enabled", (Object)true);
    public static final Option<String> ZK_INHERIT_ACL_PATH = Option.create((String)"pack.zookeeper.znodePathInheritedACLs", null);
    public static final Option<Duration> CACHE_TARGET_REPLICATION_TIMEOUT = Option.create((String)"pack.cacheTarget.replication.timeout", (Object)new Duration(10L, TimeUnit.MINUTES));

    private ClusterOptions() {
        throw new AssertionError();
    }

    public static Options defaults() {
        return Options.create();
    }
}

