/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.pack.replication;

import com.complexible.stardog.pack.replication.ExpelFailedException;
import com.complexible.stardog.pack.replication.NotInCluster;
import com.complexible.stardog.server.InvalidConfigurationException;
import com.stardog.ErrorCode;
import com.stardog.SkeletonErrorParser;

public class ClusterErrorParser
extends SkeletonErrorParser {
    static final ClusterErrorParser INSTANCE = new ClusterErrorParser();
    public static final String CLUSTER_ERROR_PREFIX = "CL";

    private ClusterErrorParser() {
    }

    protected Throwable toThrowable(ErrorCode thePec, String theErrorMsg) {
        return ((ClusterErrorCode)thePec).toException(theErrorMsg);
    }

    protected boolean canBeParsed(String theErrorCode) {
        return theErrorCode.startsWith(CLUSTER_ERROR_PREFIX);
    }

    protected ErrorCode[] getErrorCodes() {
        return ClusterErrorCode.values();
    }

    protected boolean codeMatches(ErrorCode thePec, Throwable theT) {
        return ((ClusterErrorCode)thePec).applies(theT);
    }

    public static enum ClusterErrorCode implements ErrorCode
    {
        EXPEL_FAILED("OEF", ErrorCode.Severity.CRITICAL){

            @Override
            Throwable toException(String msg) {
                return new ExpelFailedException(msg);
            }

            @Override
            boolean applies(Throwable t) {
                return t instanceof ExpelFailedException;
            }
        }
        ,
        NOT_IN_CLUSTER("NIC", ErrorCode.Severity.CRITICAL){

            @Override
            Throwable toException(String msg) {
                return new NotInCluster(msg);
            }

            @Override
            boolean applies(Throwable t) {
                return t instanceof NotInCluster;
            }
        }
        ,
        MISCONFIGURED_CLUSTER("NIC", ErrorCode.Severity.CRITICAL){

            @Override
            Throwable toException(String msg) {
                return new InvalidConfigurationException(msg);
            }

            @Override
            boolean applies(Throwable t) {
                return t instanceof InvalidConfigurationException;
            }
        };

        private final String formattedCode;
        private final ErrorCode.Severity severity;

        private ClusterErrorCode(String formattedCode, ErrorCode.Severity severity) {
            this.formattedCode = ClusterErrorParser.CLUSTER_ERROR_PREFIX + formattedCode + severity.getEncodedString();
            this.severity = severity;
        }

        public String getFormattedString() {
            return this.formattedCode;
        }

        public ErrorCode.Severity getSeverity() {
            return this.severity;
        }

        public String getCategory() {
            return ClusterErrorParser.CLUSTER_ERROR_PREFIX;
        }

        abstract Throwable toException(String var1);

        abstract boolean applies(Throwable var1);
    }
}

