/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl.tx;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.tx.api.logging.ClosableLogHandler;
import com.complexible.tx.api.logging.LogHandler;
import com.complexible.tx.api.logging.TxLogRecord;
import java.util.Objects;
import java.util.UUID;

class RangeFilterLogHandler
implements ClosableLogHandler {
    private final AdminConnection.TxLogRange mTxLogRange;
    private final LogHandler mDelegate;
    private int mFilteredCount = 0;
    private boolean mInRange = false;
    private final long mStartTs;
    private final long mEndTs;

    public RangeFilterLogHandler(AdminConnection.TxLogRange range, LogHandler delegate) {
        boolean endProvided;
        this.mDelegate = delegate;
        boolean startProvided = range.startTxId != null || range.startDate != null;
        boolean bl = endProvided = range.endTxId != null || range.endDate != null;
        if (!startProvided || !endProvided) {
            this.close();
            throw new IllegalArgumentException("Both start and end identifiers (TxId or Date) must be provided for range filtering");
        }
        this.mTxLogRange = range;
        this.mStartTs = range.startDate != null ? range.startDate.toEpochMilli() : Long.MIN_VALUE;
        this.mEndTs = range.endDate != null ? range.endDate.toEpochMilli() : Long.MAX_VALUE;
    }

    private boolean matchStart(TxLogRecord theRecord) {
        if (theRecord.getType() == TxLogRecord.RecordType.Started) {
            UUID recordUuid = Objects.requireNonNull(theRecord.getUUID(), "Started record must have a UUID");
            if (this.mStartTs != Long.MIN_VALUE && theRecord.hasValidTimestamp() && theRecord.getLogTimestamp() >= this.mStartTs) {
                return true;
            }
            return recordUuid.equals(this.mTxLogRange.startTxId);
        }
        return false;
    }

    private boolean matchEndUUID(TxLogRecord theRecord) {
        if (theRecord.getType() == TxLogRecord.RecordType.Done) {
            UUID recordUuid = Objects.requireNonNull(theRecord.getUUID(), "Done record must have a UUID");
            return recordUuid.equals(this.mTxLogRange.endTxId);
        }
        return false;
    }

    private boolean outOfEndTimeRange(TxLogRecord theRecord) {
        if (theRecord.hasValidTimestamp() && this.mEndTs != Long.MAX_VALUE) {
            return theRecord.getLogTimestamp() > this.mEndTs;
        }
        return false;
    }

    public void handleRecord(TxLogRecord theRecord) {
        if (!this.mInRange && this.matchStart(theRecord)) {
            this.mInRange = true;
        }
        if (this.mInRange) {
            boolean outOfEndUUID = this.matchEndUUID(theRecord);
            boolean outOfEndTime = this.outOfEndTimeRange(theRecord);
            if (outOfEndUUID || outOfEndTime) {
                this.mInRange = false;
                if (!outOfEndUUID) {
                    return;
                }
            }
            this.mDelegate.handleRecord(theRecord);
            ++this.mFilteredCount;
        }
    }

    public void close() {
        if (this.mDelegate instanceof AutoCloseable) {
            try {
                ((AutoCloseable)this.mDelegate).close();
            }
            catch (Exception e) {
                throw new StardogException("Error closing delegate log handler", (Throwable)e);
            }
        }
    }

    public int getFilteredCount() {
        return this.mFilteredCount;
    }
}

