/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.security.ActionType;
import com.complexible.stardog.security.Permissions;
import com.complexible.stardog.security.ResourceExistsException;
import com.complexible.stardog.security.ResourceInvalidNameException;
import com.complexible.stardog.security.ResourceInvalidTypeException;
import com.complexible.stardog.security.ResourceNotFoundException;
import com.complexible.stardog.security.SecurityResourceType;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;

@Command(name="revoke", description="Revokes user permission.", discussion="Revoke a permission held by a user.", examples={" * Revoke the write permission for user over a database", "   $ stardog-admin user revoke -a write -o db:theDb theUser"})
public final class UserRevoke
extends SecureStardogAdminCommand<Void> {
    @Option(required=true, name={"-a", "--action"}, description="Action to be permitted: [read,write,create,delete,grant,revoke,execute,all].", title="action")
    public String mAction;
    @Option(required=true, name={"-o", "--object"}, description="Target resource (user:username, db:databasename).", title="obj")
    public String mObject;
    @Arguments(required=true, description="User whose permission is to be revoked.", title={"username"})
    public String mRevokeUsername;

    @Inject
    public UserRevoke(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        ActionType aActionType = this.getActionType(this.mAction);
        if (aActionType == null) {
            throw new CliException(UserRevoke.get("revoke.invalid.action", this.mAction));
        }
        SecurityResourceType aResourceType = this.getResourceType(this.mObject);
        String aResourceName = this.getResourceName(this.mObject);
        try {
            theConn.getPermissionManager().deleteUserPerm(Permissions.create((String)this.mRevokeUsername, (ActionType)aActionType, (SecurityResourceType)aResourceType, (String)aResourceName, (String[])new String[0]));
            System.out.println(UserRevoke.get("revoke.success", new Object[0]));
        }
        catch (ResourceNotFoundException e) {
            throw new CliException(e.getMessage());
        }
        catch (ResourceExistsException e) {
            throw new CliException(UserRevoke.get("revoke.permission.not.exist", new Object[0]));
        }
        catch (ResourceInvalidTypeException e) {
            throw new CliException(UserRevoke.get("grant.invalid.resource.type", aResourceType.id()));
        }
        catch (ResourceInvalidNameException e) {
            throw new CliException(UserRevoke.get("grant.invalid.resource.name", aResourceName));
        }
    }
}

