/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.Pattern;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.security.ResourceNotFoundException;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;

@Command(name="removerole", description="Removes a role from a user.", discussion="Removes a role from a user effectively removing all permissions granted to the user via the role.", examples={"* Remove the 'writer' role from the user 'bob':", "    $ stardog-admin user removerole --role writer bob"})
public final class UserRemoveRole
extends SecureStardogAdminCommand<Void> {
    @Option(required=true, name={"-R", "--role"}, title="role", description="Role to be removed.")
    @Pattern(regex="^[A-Za-z0-9_]{1}[A-Za-z0-9_/\\-\\@\\.\\+]*$")
    public String mRole;
    @Arguments(required=true, title={"username"}, description="User whose role is to be removed.")
    @Pattern(regex="^[A-Za-z0-9_]{1}[A-Za-z0-9_/\\-\\@\\.\\+]*$")
    public String mUsername;

    @Inject
    public UserRemoveRole(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        try {
            theConn.getUserManager().deleteUserRole(this.mUsername, this.mRole);
            System.out.println(UserRemoveRole.get("user.remove.role.success", this.mRole, this.mUsername));
        }
        catch (ResourceNotFoundException e) {
            throw new CliException(e.getMessage());
        }
    }
}

