/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.Permission;
import com.complexible.stardog.security.ResourceNotFoundException;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import java.util.HashMap;
import java.util.HashSet;

@Command(name="permission", description="List a user's permissions", discussion="Lists all of a user's permissions to perform a specific actions against resources within Stardog.", examples={"* List a users's permissions", "  $ stardog-admin user permission theUserName"})
public final class UserPermission
extends Permission {
    @Arguments(required=true, description="User whose permissions are to be listed.", title={"username"})
    public String mPermissionUsername;

    @Inject
    public UserPermission(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        try {
            HashMap aPermissionsBySource = Maps.newHashMap();
            HashSet aUserPermissions = Sets.newHashSet((Iterable)theConn.getPermissionManager().getUserPerms(this.mPermissionUsername));
            String aUserSource = "[" + this.mPermissionUsername + "]";
            if (!aUserPermissions.isEmpty()) {
                aPermissionsBySource.put(aUserSource, aUserPermissions);
            }
            HashSet aRoles = Sets.newHashSet((Iterable)theConn.getUserManager().getUserRoles(this.mPermissionUsername));
            for (String aRole : aRoles) {
                HashSet aRolePerms = Sets.newHashSet((Iterable)theConn.getPermissionManager().getRolePerms(aRole));
                if (aRolePerms.isEmpty()) continue;
                aPermissionsBySource.put(aRole, aRolePerms);
            }
            if (aPermissionsBySource.isEmpty()) {
                System.out.println(UserPermission.get("user.no.permissions", this.mPermissionUsername));
            } else {
                this.outputPermissionStrings(aPermissionsBySource, true);
            }
        }
        catch (ResourceNotFoundException e) {
            throw new CliException(UserPermission.get("no.such.user", this.mPermissionUsername));
        }
    }
}

