/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.dataexporter.TextTabularOutput;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.airlift.command.Command;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

@Command(name="list", description="Lists all users.")
public final class UserList
extends SecureStardogAdminCommand<Void> {
    private static final String[] SIMPLE_VIEW_COLS = new String[]{"Username"};
    private static final String[] ALL_VIEW_COLS = new String[]{"Username", "Superuser", "Enabled", "Roles"};

    @Inject
    public UserList(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        String[] aCols = this.mVerbose ? ALL_VIEW_COLS : SIMPLE_VIEW_COLS;
        TextTabularOutput aOutput = new TextTabularOutput((OutputStream)System.out, aCols);
        ArrayList aUsers = Lists.newArrayList((Iterable)theConn.getUserManager().getAllUsers());
        Collections.sort(aUsers);
        for (String aUsername : aUsers) {
            Object[] aRow = new Object[aCols.length];
            aRow[0] = aUsername;
            if (this.mVerbose) {
                this.printAllInfo(theConn, aUsername, aRow);
            }
            aOutput.addRow(aRow);
        }
        aOutput.output();
    }

    private void printAllInfo(AdminConnection theConn, String theUsername, Object[] aRow) {
        Collection<Object> aRoles = Collections.emptyList();
        boolean aSuperUser = false;
        boolean aEnabled = false;
        try {
            aRoles = theConn.getUserManager().getUserRoles(theUsername);
        }
        catch (StardogException stardogException) {
            // empty catch block
        }
        try {
            aSuperUser = theConn.getUserManager().isSuperUser(theUsername);
        }
        catch (StardogException stardogException) {
            // empty catch block
        }
        try {
            aEnabled = theConn.getUserManager().isUserEnabled(theUsername);
        }
        catch (StardogException stardogException) {
            // empty catch block
        }
        int aCurrentCol = 1;
        aRow[aCurrentCol++] = aSuperUser;
        aRow[aCurrentCol++] = aEnabled;
        StringBuffer aRoleString = new StringBuffer();
        boolean aFirstRole = true;
        for (String string : aRoles) {
            if (!aFirstRole) {
                aRoleString.append(",");
            }
            aFirstRole = false;
            aRoleString.append(string);
        }
        aRow[aCurrentCol++] = aRoleString.toString();
    }
}

