/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.Pattern;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.security.ActionType;
import com.complexible.stardog.security.Permissions;
import com.complexible.stardog.security.ResourceExistsException;
import com.complexible.stardog.security.ResourceInvalidNameException;
import com.complexible.stardog.security.ResourceInvalidTypeException;
import com.complexible.stardog.security.ResourceNotFoundException;
import com.complexible.stardog.security.SecurityResourceType;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;

@Command(name="grant", description="Grants a permission to a user.", discussion="Grants a user permission to perform a specific action against a resource within Stardog.", examples={"* Grant a user the read permission to a database", "  $ stardog-admin user grant -a read -o db:myDb theUserName"})
public final class UserGrant
extends SecureStardogAdminCommand<Void> {
    @Option(required=true, name={"-a", "--action"}, description="Action to be permitted: [read,write,create,delete,grant,revoke,execute,all].", title="action")
    @Pattern(regex="(create|delete|read|write|revoke|grant|execute|all)")
    public String mAction;
    @Option(required=true, name={"-o", "--object"}, description="Target resource (user:username, db:databasename).", title="obj")
    public String mObject;
    @Arguments(required=true, description="User to be granted the permission.", title={"username"})
    public String mGrantUsername;

    @Inject
    public UserGrant(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        ActionType aActionType = this.getActionType(this.mAction);
        if (aActionType == null) {
            throw new CliException(UserGrant.get("grant.invalid.action", this.mAction));
        }
        SecurityResourceType aResourceType = this.getResourceType(this.mObject);
        String aResourceName = this.getResourceName(this.mObject);
        try {
            theConn.getPermissionManager().addUserPerm(Permissions.create((String)this.mGrantUsername, (ActionType)aActionType, (SecurityResourceType)aResourceType, (String)aResourceName, (String[])new String[0]));
            System.out.println(UserGrant.get("grant.success", new Object[0]));
        }
        catch (ResourceNotFoundException e) {
            throw new CliException(e.getMessage());
        }
        catch (ResourceExistsException e) {
            throw new CliException(UserGrant.get("grant.permission.already.exists", "User", this.mGrantUsername));
        }
        catch (ResourceInvalidTypeException e) {
            throw new CliException(UserGrant.get("grant.invalid.resource.type", aResourceType.id()));
        }
        catch (ResourceInvalidNameException e) {
            throw new CliException(UserGrant.get("grant.invalid.resource.name", aResourceName));
        }
    }
}

