/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.Pattern;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.security.ResourceNotFoundException;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;

@Command(name="enable", description="Enables a user.", discussion="Enables a user so that the username can be used for login. ", examples={"* Enable the user 'bob':", "    $ stardog-admin user enable bob"})
public final class UserEnable
extends SecureStardogAdminCommand<Void> {
    @Arguments(required=true, title={"username"}, description="User name")
    @Pattern(regex="^[A-Za-z0-9_]{1}[A-Za-z0-9_/\\-\\@\\.\\+]*$")
    public String mUsername;

    @Inject
    public UserEnable(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        try {
            theConn.getUserManager().setUserEnabled(this.mUsername, true);
            System.out.println(UserEnable.get("user.enable.success", this.mUsername));
        }
        catch (ResourceNotFoundException e) {
            throw new CliException(UserEnable.get("no.such.user", this.mUsername));
        }
    }
}

