/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.Pattern;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.security.OperationNotSupportedException;
import com.complexible.stardog.security.ResourceNotFoundException;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;

@Command(name="remove", description="Removes a user.")
public final class UserDrop
extends SecureStardogAdminCommand<Void> {
    @Arguments(required=true, description="User to be removed.", title={"username"})
    @Pattern(regex="^[A-Za-z0-9_]{1}[A-Za-z0-9_/\\-\\@\\.\\+]*$")
    public String mDropUsername;

    @Inject
    public UserDrop(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        try {
            theConn.getUserManager().deleteUser(this.mDropUsername);
            System.out.println(UserDrop.get("user.drop.success", this.mDropUsername));
        }
        catch (ResourceNotFoundException e) {
            throw new CliException(UserDrop.get("no.such.user", this.mDropUsername));
        }
        catch (OperationNotSupportedException e) {
            throw new CliException(UserDrop.get("user.drop.not.permitted", e.getMessage()));
        }
    }
}

