/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.Pattern;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.security.OperationNotSupportedException;
import com.complexible.stardog.security.ResourceNotFoundException;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;

@Command(name="disable", description="Disables a user.", discussion="Disables a user so that the username can no longer be used to login. The last enabled superuser cannot be disabled.", examples={"* Disable the user 'bob':", "    $ stardog-admin user disable bob"})
public final class UserDisable
extends SecureStardogAdminCommand<Void> {
    @Arguments(required=true, title={"username"}, description="User to be disabled.")
    @Pattern(regex="^[A-Za-z0-9_]{1}[A-Za-z0-9_/\\-\\@\\.\\+]*$")
    public String mUsername;

    @Inject
    public UserDisable(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        try {
            theConn.getUserManager().setUserEnabled(this.mUsername, false);
            System.out.println(UserDisable.get("user.disable.success", this.mUsername));
        }
        catch (ResourceNotFoundException e) {
            throw new CliException(UserDisable.get("no.such.user", this.mUsername));
        }
        catch (OperationNotSupportedException e) {
            throw new CliException(UserDisable.get("user.disable.not.permitted", this.mUsername));
        }
    }
}

