/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.Pattern;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.security.ResourceExistsException;
import com.complexible.stardog.security.ResourceNotFoundException;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;

@Command(name="addrole", description="Assigns a role to a user.", discussion="Associates a role with a user which will grant the user all the permissions explicitly assigned to the role.", examples={"* Give the user 'bob' the role 'writer':", "    $ stardog-admin user addrole --role writer bob"})
public final class UserAddRole
extends SecureStardogAdminCommand<Void> {
    @Option(required=true, name={"-R", "--role"}, title="role", description="Role to be associated with the user.")
    @Pattern(regex="^[A-Za-z0-9_]{1}[A-Za-z0-9_/\\-\\@\\.\\+]*$")
    public String mRole;
    @Arguments(required=true, title={"username"}, description="User to be associated with the role.")
    @Pattern(regex="^[A-Za-z0-9_]{1}[A-Za-z0-9_/\\-\\@\\.\\+]*$")
    public String mUsername;

    @Inject
    public UserAddRole(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        try {
            theConn.getUserManager().addUserRole(this.mUsername, this.mRole);
            System.out.println(UserAddRole.get("user.add.role.success", this.mRole, this.mUsername));
        }
        catch (ResourceExistsException e) {
            throw new CliException(UserAddRole.get("user.add.role.existing", this.mUsername, this.mRole));
        }
        catch (ResourceNotFoundException e) {
            throw new CliException(e.getMessage());
        }
    }
}

