/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.Pattern;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.cli.impl.CliUtil;
import com.complexible.stardog.security.IllegalPasswordException;
import com.complexible.stardog.security.ResourceExistsException;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.util.Arrays;

@Command(name="add", description="Adds a new user.", discussion="Create a new user with the specified user name and add them to the system.", examples={"* Add a new user and prompt for new password", "    $ stardog-admin user add newUser"})
public final class UserAdd
extends SecureStardogAdminCommand<Void> {
    @Option(name={"-s", "--superuser"}, description="Superuser flag. If this flag is set, the new user will be a super user.", arity=0)
    public boolean mSuperUser = false;
    @Arguments(required=true, description="User name.", title={"username"})
    @Pattern(regex="^[A-Za-z0-9_]{1}[A-Za-z0-9_/\\-\\@\\.\\+]*$")
    public String mAddUsername;
    @Option(name={"-N", "--new-password"}, description="Password for new user. If not provided, the user will be prompted to enter it.", title="password")
    @Pattern(regex="(.)*")
    public String mPassword = null;

    @Inject
    public UserAdd(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        try {
            boolean aNoPassword;
            if (this.mAddUsername.length() > 4095) {
                throw new CliException(UserAdd.get("user.add.length.limit.exceeded", this.mAddUsername));
            }
            char[] aNewPassword = null;
            boolean bl = aNoPassword = this.mPassword == null || this.mPassword.isEmpty();
            if (aNoPassword) {
                char[] aNewPasswordRepeat;
                aNewPassword = CliUtil.readPassword(this.mReader, UserAdd.get("passwd.new.password", this.mAddUsername));
                if (!Arrays.equals(aNewPassword, aNewPasswordRepeat = CliUtil.readPassword(this.mReader, UserAdd.get("passwd.new.password.confirm", this.mAddUsername)))) {
                    throw new CliException(UserAdd.get("passwd.confirmation.no.match", new Object[0]));
                }
            } else {
                aNewPassword = this.mPassword.toCharArray();
            }
            if (aNewPassword.length == 0) {
                throw new CliException(UserAdd.get("passwd.empty.password", new Object[0]));
            }
            theConn.getUserManager().addUser(this.mAddUsername, this.mSuperUser, aNewPassword);
            System.out.println(UserAdd.get("user.add.success", this.mAddUsername));
        }
        catch (IllegalPasswordException e) {
            throw new CliException(UserAdd.get("passwd.invalid", new Object[0]));
        }
        catch (ResourceExistsException e) {
            throw new CliException(UserAdd.get("user.add.already.exists", this.mAddUsername));
        }
    }
}

