/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.base.DateTime;
import com.complexible.common.dataexporter.TextTabularOutput;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.TxInfo;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.SimpleQueryCommand;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import io.airlift.command.Command;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

@Command(name="list", description="Lists all open transactions for the database.", examples={"* List all open transactions for the database", "    $ stardog tx list myDb", ""})
public final class TxList
extends SimpleQueryCommand<Void> {
    @Inject
    public TxList(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void execute(Connection theConn) throws StardogException {
        Collection aTxInfos = theConn.transactions();
        if (aTxInfos.size() > 0) {
            String[] aCols = new String[]{"Tx ID", "User", "Start Time", "Status"};
            TextTabularOutput aOutput = new TextTabularOutput((OutputStream)System.out, aCols);
            ImmutableList aSortedTxInfos = Ordering.natural().onResultOf(TxInfo::getStartTime).immutableSortedCopy((Iterable)aTxInfos);
            for (TxInfo aInfo : aSortedTxInfos) {
                aOutput.addRow(new Object[]{aInfo.getID().toString(), aInfo.getUser(), new DateTime(aInfo.getStartTime()), StringUtils.capitalize((String)aInfo.getStatus().toString().toLowerCase())});
            }
            aOutput.output();
        }
        System.out.printf("%n%d transaction(s)%n", aTxInfos.size());
    }

    @Override
    protected String connectionString() {
        return this.mDbName;
    }
}

