/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.timer.DurationFormat;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.ConnectionCommand;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import java.util.List;
import java.util.UUID;

@Command(name="commit", description="Commits a new transaction.", examples={"* Commits a transaction", "    $ stardog tx commit myDb 228684a7-3e9d-435e-8dab-f0f900448f92", ""})
public final class TxCommit
extends ConnectionCommand<Void> {
    @Arguments(required=true, description="The name of the database or the full connection string of the database to connect to. If only the name is provided, the default server URL will be prepended to the name of the database in order to construct the connection string. Connection parameters such as ';reasoning=true' can be included in the provided database name. Connection parameters specified like this can be overridden by specific options on the command. The default server URL will be read from the JVM argument 'stardog.default.cli.server'. If the JVM argument is not set, the default value 'http://localhost:5820' is used. If the server URL has no explicit port value, the default port value '5820' is used.  To use a secure connection, you should specify the full connection string and postfix 's' to the protocol, e.g. https. The second argument is the ID of the transaction to be committed.", title={"dbname", "txId"})
    public List<String> mArgs;
    private String mDbName;
    private UUID mTxId;

    @Inject
    public TxCommit(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void execute(Connection theConn) throws StardogException {
        long aStartTime = System.currentTimeMillis();
        theConn.commit();
        long aTime = System.currentTimeMillis() - aStartTime;
        System.out.println(TxCommit.get("tx.commit.success", DurationFormat.LONG.format(aTime)));
    }

    @Override
    public UUID getTxId() {
        return this.mTxId;
    }

    @Override
    protected String connectionString() {
        if (this.mDbName != null) {
            return this.mDbName;
        }
        if (this.mArgs != null && !this.mArgs.isEmpty()) {
            this.mDbName = this.mArgs.get(0);
            if (this.mArgs.size() > 1) {
                this.mTxId = UUID.fromString(this.mArgs.get(1));
            }
        }
        return this.mDbName;
    }
}

