/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.base.Streams;
import com.complexible.common.dataexporter.TextTabularOutput;
import com.complexible.common.timer.DurationFormat;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.ConnectionConfiguration;
import com.complexible.stardog.api.test.Test;
import com.complexible.stardog.api.test.TestReader;
import com.complexible.stardog.api.test.TestResult;
import com.complexible.stardog.api.test.TestRunner;
import com.complexible.stardog.api.test.TestSuite;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.ConnectionCommand;
import com.google.common.base.Stopwatch;
import com.google.common.collect.LinkedHashMultiset;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@Command(name="run", description="Run the specified tests.", examples={"* Run the test definition file test.rdf:", "    $ stardog test run path/to/test.rdf", ""})
public class TestRun
extends ConnectionCommand<Void> {
    @Arguments(required=true, description="Test definitions to run. Test definition is an RDF file containing the definitions for the test.", title={"files"})
    public List<String> files;
    @Option(name={"--show-plans"}, description="Print query plan before running each query.", arity=0)
    protected boolean showPlans = false;
    @Option(name={"--stop-at-first-failure"}, description="Stop at first failure.", arity=0)
    protected boolean stopAtFirstFailure = false;
    @Option(name={"--repeat-update-queries"}, description="Run update queries as many times as specified in the test definition. By default, update queries are run only once regardless of test settings.", arity=0)
    protected boolean repeatUpdateQueries = false;

    @Inject
    public TestRun(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void execute(Connection theConn) throws StardogException {
        throw new CliException("Internal error: Unreachable code");
    }

    @Override
    protected void execute(ConnectionConfiguration config) {
        TestReader reader = new TestReader();
        List suites = this.files.stream().map(x$0 -> Paths.get(x$0, new String[0])).map(Streams.unchecked(arg_0 -> ((TestReader)reader).read(arg_0))).collect(Collectors.toList());
        TestSuite suite = suites.size() == 1 ? (TestSuite)suites.get(0) : new TestSuite("auto-generated", Paths.get(".", new String[0]), new Test(), suites);
        Stopwatch watch = Stopwatch.createStarted();
        TestRunner runner = new TestRunner(config);
        runner.setShowPlans(this.showPlans);
        runner.setShowStackTraces(this.mVerbose);
        runner.setStopOnFirstFailure(this.stopAtFirstFailure);
        runner.setRunUpdateQueriesOnce(!this.repeatUpdateQueries);
        List results = runner.run(suite);
        TestRun.printResults(results, watch);
    }

    private static void printResults(List<TestResult> results, Stopwatch watch) {
        String[] cols = new String[]{"Result", "Test", "Message"};
        TextTabularOutput table = new TextTabularOutput((OutputStream)System.out, cols);
        String summary = results.stream().peek(result -> table.addRow(new Object[]{result.type(), result.test().name(), result.message().split("\n", 2)[0]})).map(TestResult::type).sorted().collect(Collectors.toCollection(LinkedHashMultiset::create)).entrySet().stream().map(e -> String.format("\t%s: %d%n", e.getElement(), e.getCount())).collect(Collectors.joining());
        table.output();
        System.out.printf("%nFinished running %d tests in %s%n%s%n", results.size(), DurationFormat.LONG.format(watch.elapsed(TimeUnit.MILLISECONDS)), summary);
    }

    @Override
    protected String connectionString() {
        return "";
    }
}

