/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.ConnectionConfiguration;
import com.complexible.stardog.api.test.Test;
import com.complexible.stardog.api.test.TestCreator;
import com.complexible.stardog.api.test.TestSuite;
import com.complexible.stardog.api.test.TestWriter;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.ConnectionCommand;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.List;

@Command(name="create", description="Create test definitions from a set of queries in a directory.", discussion="Create test definitions from a set of queries in a directory. The command will recursively traverse the directory, find query files matching the provided glob expression (default: *.{sparql,rq}), execute the query against the provided database and generate one test definition file for each directory. Test definition file will contain one test for each query file found. The expected time for the query will be computed by running the query first as many as {@code --runs} times taking the average. The query is run as many as {@code --warmups} times first but execution times for warmups are disregarded. The expected results for the queries are saved into a file in the same directory as the query. If queries return too many results or results change at every execution (e.g. due to {@code UUID} or {@code RAND} functions) then {@code --only-counts} option can be used to record the number of results expected instead of actual query results.", examples={"* Creates a test definition file for myDb using default settings:", "    $ stardog test create myDb path/to/queryDir", ""})
public class TestCreate
extends ConnectionCommand<Void> {
    public static final String DEFAULT_GLOB = "*.{sparql,rq}";
    @Arguments(required=true, description="The name of the database or the full connection string of the database to connect to. If only the name is provided, the default server URL will be prepended to the name of the database in order to construct the connection string. Connection parameters such as ';reasoning=true' can be included in the provided database name. Connection parameters specified like this can be overridden by specific options on the command. The default server URL will be read from the JVM argument 'stardog.default.cli.server'. If the JVM argument is not set, the default value 'http://localhost:5820' is used. If the server URL has no explicit port value, the default port value '5820' is used.  To use a secure connection, you should specify the full connection string and postfix 's' to the protocol, e.g. https. Subsequent argument is a directory that contains a set of SPARQL queries. The directory will be traversed recursively and a test manifest filewill be created under each", title={"directory"})
    private List<String> args;
    private String dir;
    @Option(name={"-w", "--warmups"}, description="The number of warmups to run. Each query in the test suite will be run these many timesbefore average query execution times are computed. The default is three (3).", title="warmups")
    public int warmups = 3;
    @Option(name={"-r", "--runs"}, description="The number of test runs to execute. Each query will be executed these many times and the expected query execution time will be computed as the average of these runs. The default is two (2).", title="runs")
    public int runs = 2;
    @Option(name={"--glob"}, description="The glob expression to use for finding files in the directory. The default is looking for fileswith extension ,sparql or .rq.", title="glob")
    public String glob = "*.{sparql,rq}";
    @Option(name={"--no-timings"}, description="Do not include expected times for queries in the test definition..", arity=0)
    protected boolean noTimings = false;
    @Option(name={"--only-counts"}, description="Include only expected number of results in the test definition and not the actual results. .", arity=0)
    protected boolean resultCount = false;

    @Inject
    public TestCreate(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void execute(Connection theConn) throws StardogException {
        throw new CliException("Internal error: Unreachable code");
    }

    @Override
    protected void execute(ConnectionConfiguration config) {
        try {
            EnumSet<TestCreator.CreateOption> options = EnumSet.noneOf(TestCreator.CreateOption.class);
            if (!this.noTimings) {
                options.add(TestCreator.CreateOption.EXPECTED_TIME);
            }
            if (this.resultCount) {
                options.add(TestCreator.CreateOption.RESULT_COUNT);
            } else {
                options.add(TestCreator.CreateOption.RESULT);
            }
            Test defaults = new Test();
            defaults.setWarmups(this.warmups);
            defaults.setRuns(this.runs);
            defaults.setReasoning(this.getReasoningSchema());
            TestSuite suite = new TestCreator(config, defaults, options).create(Paths.get(this.dir, new String[0]), this.glob);
            new TestWriter().writeRecursively(suite);
            System.out.printf("Created a total of %d tests. Test definition file saved in %s.%n", suite.count(), suite.dir());
        }
        catch (IOException e) {
            throw new CliException(e);
        }
    }

    @Override
    protected String connectionString() {
        String conn = null;
        if (this.args != null && !this.args.isEmpty()) {
            conn = this.args.get(0);
            if (this.args.size() != 1) {
                this.dir = this.args.get(1);
            }
        }
        return conn;
    }
}

