/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.rdf.rio.TurtleValueParser;
import com.complexible.stardog.ImmutableStoredQuery;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.StoredQuery;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.cli.impl.CliUtil;
import com.complexible.stardog.cli.impl.StoredQueryAdd;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.stardog.stark.IRI;
import com.stardog.stark.Namespace;
import com.stardog.stark.Namespaces;
import com.stardog.stark.Value;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

@Command(name="set", description="Sets new annotations to an existing stored query or updates the existing ones", discussion="Sets new annotations to an existing stored query or updates the existing ones. If existing values are needed to be kept, --append option helps for it.", examples={"* Sets an annotation which is a IRI-RDF Value pair", "  $ stardog-admin stored set queryName -a IRI_key=RDF_value", "", "* Sets multiple annotations which are IRI-RDF Value pairs, if a key exists, its value would be updated", "  $ stardog-admin stored set queryName -a IRI_key=RDF_value1 IRI_key2=RDF_value2 --", "", "* Sets multiple annotations which are IRI-RDF Value pairs, if a key exists, its value would be appended", "  $ stardog-admin stored set queryName -a IRI_key=RDF_value2 --append --", ""})
public final class StoredQuerySet
extends SecureStardogAdminCommand<Void> {
    @Option(name={"-a", "--annotation"}, description="One or more configuration annotations to be saved for a stored query. An annotation's key must be IRI and its value RDF value.Each annotation is a 'key=value' pair; multiple annotations are separated by whitespaces, e.g., '-o \"IRI_key1=RDF_value1 IRIkey2=RDF_value1\"'. ", title="annotations", arity=0x7FFFFFFF)
    public List<String> mAnnotations = Lists.newArrayList();
    @Option(name={"--append"}, description="Appending the value of the annotation belonging to the key instead of overwriting it.")
    public boolean mAppend = false;
    @Option(name={"-d", "--database"}, title="db", description="The database that the query will be associated with.")
    public String mDb;
    @Option(name={"--description"}, title="description", description="A human readable description of the query.")
    public String mDescription;
    @Option(name={"-q", "--query"}, description="The SPARQL query string to store.")
    public String mQuery;
    @Option(name={"--private"}, description="Restrict sharing this query with other users if sharing previously enabled.")
    public boolean mPrivate = false;
    @Option(name={"--reasoning"}, allowedValues={"on", "off"}, description="Switch reasoning boolean value previously specified for this stored query. If this flag is set then the stored query will always be executed with reasoning even if the reasoning is not enabled for the connection explicitly. The stored query will use the default reasoning schema. ")
    public String mReasoning;
    @Option(name={"--schema"}, description="Specify the reasoning schema that will be used for this query. If this flag is set then the stored query  will always be executed with the specified schema even if the reasoning is not enabled for the connection explicitly or the connection has another schema specified.")
    public String mSchema;
    @Option(name={"--trigger"}, description="Is this a query whose results will be watched.")
    public String mTrigger = null;
    @Option(name={"--trigger-limit"}, title="limit", description="Number of results which will be watched.")
    public String mTriggerLimit;
    @Option(name={"--trigger-schedule"}, title="schedule", description="Frequency of the trigger notifications in seconds. Should the contents of the query change, updates will be send.")
    public String mTriggerFrequency;
    @Option(name={"--trigger-timeout"}, title="timeout", description="Timeout used for trigger querys in seconds. If the query does not return in this time, the trigger will be disabled.")
    public String mTriggerTimeout;
    @Arguments(required=true, title={"storedQueryName"}, description="The name of the stored query")
    public String mStoredQueryName;

    @Inject
    public StoredQuerySet(PasswordReader theReader) {
        super(theReader);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        aStoredQuery = theConn.getStoredQueries().get(this.mStoredQueryName);
        aBuilder = new ImmutableStoredQuery.Builder(aStoredQuery);
        aNamespaces = StoredQueryAdd.getNamespaceIterable(aStoredQuery.getDatabase(), theConn);
        if (this.mAppend) ** GOTO lbl9
        if (aStoredQuery.getAnnotations().isEmpty()) {
lbl9:
            // 2 sources

            StoredQuerySet.readAnnotations(this.mAnnotations, aNamespaces).forEach((BiConsumer<IRI, Value>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, annotation(com.stardog.stark.IRI com.stardog.stark.Value ), (Lcom/stardog/stark/IRI;Lcom/stardog/stark/Value;)V)((ImmutableStoredQuery.Builder)aBuilder));
        } else {
            originalAnnotations = aStoredQuery.getAnnotations();
            annotationsToBeSet = StoredQuerySet.readAnnotations(this.mAnnotations, aNamespaces);
            aBuilder.clearAnnotations();
            for (IRI annotationKey : originalAnnotations.keySet()) {
                if (annotationsToBeSet.containsKey(annotationKey)) {
                    aBuilder.annotation(annotationKey, annotationsToBeSet.get(annotationKey));
                    annotationsToBeSet.remove(annotationKey);
                    continue;
                }
                for (Value annotationValue : originalAnnotations.get((Object)annotationKey)) {
                    aBuilder.annotation(annotationKey, annotationValue);
                }
            }
            annotationsToBeSet.forEach((BiConsumer<IRI, Value>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, annotation(com.stardog.stark.IRI com.stardog.stark.Value ), (Lcom/stardog/stark/IRI;Lcom/stardog/stark/Value;)V)((ImmutableStoredQuery.Builder)aBuilder));
        }
        System.out.println(StoredQuerySet.get("stored.set", new Object[]{this.mStoredQueryName}));
        this.setOptions(aBuilder, aStoredQuery, theConn);
        theConn.getStoredQueries().update((StoredQuery)aBuilder.build());
    }

    protected static Map<IRI, Value> readAnnotations(Collection<String> theAnnotations, Iterable<Namespace> theNamespaces) throws CliException {
        HashMap aAnnotationMultiMap = Maps.newHashMap();
        if (!theAnnotations.isEmpty()) {
            TurtleValueParser aParser = theNamespaces == null || Iterables.isEmpty(theNamespaces) ? new TurtleValueParser((Iterable)Namespaces.DEFAULT) : new TurtleValueParser(theNamespaces);
            for (String aAnnotation : theAnnotations) {
                String[] aOptionPair = aAnnotation.split("=", 2);
                if (aOptionPair.length != 2) {
                    throw new CliException("Missing '=' for option: " + aAnnotation);
                }
                try {
                    aAnnotationMultiMap.put((IRI)aParser.parse(aOptionPair[0]), aParser.parse(aOptionPair[1]));
                }
                catch (Exception e) {
                    throw new CliException("Invalid option key or value: " + aAnnotation, e);
                }
            }
        }
        return aAnnotationMultiMap;
    }

    private void setOptions(ImmutableStoredQuery.Builder theBuilder, StoredQuery theStoredQuery, AdminConnection theConn) {
        if (this.mQuery != null) {
            theBuilder.query(CliUtil.cleanQuery(this.mQuery));
        }
        if (this.mDb != null) {
            theBuilder.database(this.mDb);
        }
        if (this.mDescription != null) {
            theBuilder.description(this.mDescription);
        }
        if (this.mReasoning != null) {
            theBuilder.reasoning(this.mReasoning.equals("on"));
            theBuilder.schema(this.mSchema == null && !theStoredQuery.isReasoning() ? "default" : this.mSchema);
        } else if (this.mSchema != null) {
            theBuilder.schema(this.mSchema);
        }
        if (theStoredQuery.isShared() && this.mPrivate) {
            theBuilder.shared(false);
        }
        if (this.mTrigger != null) {
            boolean isTrigger = Boolean.parseBoolean(this.mTrigger);
            if (isTrigger) {
                if (this.mTriggerLimit != null) {
                    theBuilder.triggerLimit(Integer.parseInt(this.mTriggerLimit));
                }
                if (this.mTriggerFrequency != null) {
                    theBuilder.triggerSchedule(Integer.parseInt(this.mTriggerFrequency));
                }
                if (this.mTriggerTimeout != null) {
                    theBuilder.triggerTimeout(Integer.parseInt(this.mTriggerTimeout));
                }
            } else {
                theBuilder.triggerLimit(0);
                theBuilder.triggerSchedule(0);
                theBuilder.triggerTimeout(0);
            }
        }
        theBuilder.creator(theStoredQuery.getCreator());
    }
}

