/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.StoredQueries;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import io.airlift.command.OptionType;

@Command(name="remove", description="Removes a stored query", discussion="Removes a stored query from the system.", examples={"* Removes the given query:", "    $ stardog-admin stored remove myQuery"})
public final class StoredQueryRemove
extends SecureStardogAdminCommand<Void> {
    @Arguments(required=false, description="Name of the stored query to delete.", title={"name"})
    public String mName;
    @Option(name={"-a", "--all"}, type=OptionType.COMMAND, description="Remove all flag. If this flag is set, all stored queries will be removed.", arity=0)
    protected boolean mAll = false;

    @Inject
    public StoredQueryRemove(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        StoredQueries queries = theConn.getStoredQueries();
        if (this.mAll) {
            if (this.mName != null) {
                throw new CliException(StoredQueryRemove.get("stored.remove.all.error", "query"));
            }
            try {
                queries.clear();
                System.out.println(StoredQueryRemove.get("stored.removed.all", "queries"));
            }
            catch (StardogException e) {
                throw new CliException(StoredQueryRemove.get("stored.removed.all.error", "queries"));
            }
        } else {
            queries.remove(this.mName);
            System.out.println(StoredQueryRemove.get("stored.removed", "query"));
        }
    }
}

