/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StoredQueries;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import java.util.List;

@Command(name="move", description="Moves a stored query", discussion="Stores the existing query or directory under a new path.", examples={"* Moves the given query:", "    $ stardog-admin stored move old/path/queryName new/path", "", "* Moves the directory to another path:", "    $ stardog-admin stored move old/path some/other/path"})
public final class StoredQueryMove
extends SecureStardogAdminCommand<Void> {
    @Arguments(required=true, description="old full path and new path", title={"oldFullPath", "newPath"})
    public final List<String> mArgs = Lists.newArrayList();

    @Inject
    public StoredQueryMove(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws Exception {
        String newName;
        String oldName = this.mArgs.size() > 0 ? this.mArgs.get(0) : null;
        String string = newName = this.mArgs.size() > 1 ? this.mArgs.get(1) : null;
        if (Strings.isNullOrEmpty((String)oldName)) {
            throw new CliException(StoredQueryMove.get("stored.no.name", new Object[0]));
        }
        if (Strings.isNullOrEmpty((String)newName)) {
            throw new CliException(StoredQueryMove.get("stored.no.new.name", new Object[0]));
        }
        StoredQueries queries = theConn.getStoredQueries();
        queries.move(oldName, newName);
        System.out.println(StoredQueryMove.get("stored.moved", "query"));
    }
}

