/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.dataexporter.TextTabularOutput;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.StoredQueries;
import com.complexible.stardog.StoredQuery;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.StoredQueryBulkGet;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import io.airlift.command.Command;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.StreamSupport;

@Command(name="list", description="Lists the queries currently stored in the system.", examples={"* Lists the names and query strings of all stored queries:", "    $ stardog-admin stored list", "", "* Lists all stored queries with more details:", "    $ stardog-admin stored list --verbose"})
public final class StoredQueryList
extends StoredQueryBulkGet {
    private static final String[] COLS = new String[]{"Name", "Database", "Query String"};
    private static final String[] VERBOSE_COLS = new String[]{"Name", "Description", "Reasoning", "Database", "Creator", "Shared", "Query String"};
    private static final String[] TRIGGER_COLS = new String[]{"Trigger", "Limit", "Frequency", "Timeout"};

    @Inject
    protected StoredQueryList(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        ArrayList<String> columns = new ArrayList<String>(List.of(this.mVerbose ? VERBOSE_COLS : COLS));
        StoredQueries aQueries = theConn.getStoredQueries();
        boolean aHasTriggers = StreamSupport.stream(aQueries.spliterator(), false).anyMatch(StoredQuery::isTrigger);
        if (aHasTriggers) {
            columns.addAll(List.of(TRIGGER_COLS));
        }
        TextTabularOutput aTable = new TextTabularOutput((OutputStream)System.out, columns.toArray(new String[0]));
        Comparator<StoredQuery> aComparator = Comparator.comparing(StoredQuery::getName);
        ImmutableList aSortedQueries = Ordering.from(aComparator).immutableSortedCopy(this.filterQueries(aQueries));
        for (StoredQuery aQuery : aSortedQueries) {
            Object[] row = this.mVerbose ? new Object[]{StoredQuery.getFullPath((StoredQuery)aQuery), aQuery.getDescription(), aQuery.isReasoning(), aQuery.getDatabase(), aQuery.getCreator(), aQuery.isShared(), aQuery.getQuery()} : new Object[]{aQuery.getName(), aQuery.getDatabase(), aQuery.getQuery()};
            if (aHasTriggers) {
                row = Arrays.copyOf(row, row.length + 4);
                Object object = row[row.length - 4] = aQuery.isTrigger() ? "Yes" : "No";
                if (aQuery.isTrigger()) {
                    row[row.length - 3] = aQuery.getTriggerLimit();
                    row[row.length - 2] = aQuery.getTriggerSchedule() > 0 ? Integer.valueOf(aQuery.getTriggerSchedule()) : "default";
                    row[row.length - 1] = aQuery.getTriggerTimeout() > 0 ? Integer.valueOf(aQuery.getTriggerTimeout()) : "default";
                }
            }
            aTable.addRow(row);
        }
        aTable.output();
        System.out.println();
        System.out.println(StoredQueryList.get("stored.count", aSortedQueries.size(), "queries"));
    }
}

