/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.rdf.rio.RDFStreams;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.StoredQueries;
import com.complexible.stardog.StoredQuery;
import com.complexible.stardog.StoredQueryIO;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.cli.impl.CliUtil;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.stardog.stark.io.FileFormat;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@Command(name="import", description="Imports the stored queries from the given RDF file", discussion="Reads stored queries from an RDF file and adds them to the Stardog server. This action is not atomic so if an error occurs at some point only some of the stored queries might be added as a result.", examples={"* Adds new stored queries:", "    $ stardog-admin stored import storedQueries.ttl", "", "* Adds stored queries overwriting any existing :", "    $ stardog-admin stored import --overwrite storedQueries.ttl"})
public final class StoredQueryImport
extends SecureStardogAdminCommand<Void> {
    @Option(name={"-f", "--format"}, description="Data format. The supported formats are NTRIPLES, RDF/XML, TURTLE, PRETTY_TURTLE, TRIG, N3, NQUADS, JSONLD. If no format is specified, the file name will be used to guess the required format.", title="rdf format")
    public String mFormat;
    @Option(name={"--compression"}, description="Compression format [GZIP, BZ2, ZIP] for the input data.", title="Compression")
    public String mCompression;
    @Option(name={"--overwrite"}, description="If set existing stored queries with the same name will be overwritten.")
    public boolean mOverwrite = false;
    @Arguments(required=true, title={"file"}, description="The file containing the RDF serialization of the stored queries.")
    public String mFile;

    @Inject
    public StoredQueryImport(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        Path aPath = Paths.get(this.mFile, new String[0]);
        RDFFormat aFormat = null;
        if (this.mFormat != null) {
            aFormat = CliUtil.getFormat(this.mFormat);
            if (aFormat == null) {
                throw new CliException(StoredQueryImport.get("query.error.noformat", this.mFormat, "NTRIPLES, RDF/XML, TURTLE, PRETTY_TURTLE, TRIG, N3, NQUADS, JSONLD"));
            }
            if (this.mCompression != null) {
                FileFormat.Compression aCompression = FileFormat.Compression.of((String)this.mCompression);
                aFormat = RDFFormats.compressedFormat((RDFFormat)aFormat, (FileFormat.Compression)aCompression);
            }
        } else {
            if (this.mCompression != null) {
                throw new CliException(StoredQueryImport.get("cmd.error.unexpected.compression", new Object[0]));
            }
            aFormat = RDFFormats.forFile((Path)aPath).orElse(RDFFormats.TURTLE);
        }
        try {
            Set aStatements = (Set)RDFStreams.forFile((Path)aPath).format(aFormat).parseInto((Collection)Sets.newHashSet());
            List aQueries = StoredQueryIO.fromRDF((Iterable)aStatements);
            StoredQueries aStoredQueries = theConn.getStoredQueries();
            for (StoredQuery aQuery : aQueries) {
                if (this.mOverwrite) {
                    aStoredQueries.update(aQuery);
                } else {
                    aStoredQueries.add(aQuery);
                }
                if (!this.mVerbose) continue;
                System.out.println("Imported stored query: " + aQuery.getName());
            }
            System.out.printf("Imported %d stored queries successfully%n", aQueries.size());
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().contains("Stored query already exists")) {
                throw new CliException(StoredQueryImport.get("stored.overwrite", "Query"));
            }
            Throwables.propagateIfPossible((Throwable)e, StardogException.class);
            throw new CliException(e);
        }
    }
}

