/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.rdf.rio.TurtleValueParser;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.StoredQuery;
import com.complexible.stardog.StoredQueryIO;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.cli.impl.StoredQueryAdd;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.stardog.stark.IRI;
import com.stardog.stark.Namespace;
import com.stardog.stark.Namespaces;
import com.stardog.stark.Value;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.OutputStream;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Command(name="get", description="Gets the specified or all of the annotations of an existing stored query.", discussion="Gets the specified or all of the annotations of an existing stored query. The annotations are listed as IRI key and RDF Value value pairs.", examples={"* Gets the RDF Value(s) information for the specified IRI keys previously added as pairs to the stored query", "  $ stardog-admin stored get queryName -a IRI_key1 IRI_key2", "", "* Gets the RDF Value(s) information for all the IRI keys previously added as pairs to the stored query", "  $ stardog-admin stored get queryName", ""})
public final class StoredQueryGet
extends SecureStardogAdminCommand<Void> {
    @Arguments(required=true, title={"storedQueryName"}, description="The file containing the RDF serialization of the stored queries.")
    public String mStoredQueryName;
    @Option(name={"-a", "--annotation"}, description="One or more configuration annotations to set for a database. Each option is IRI keys; multiple annotations are separated by whitespaces, e.g., '-o \"IRI_key1 IRI_key2\"'. ", title="options", arity=0x7FFFFFFF)
    public List<String> mAnnotations = Lists.newArrayList();

    @Inject
    public StoredQueryGet(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        StoredQuery aStoredQuery = theConn.getStoredQueries().get(this.mStoredQueryName);
        Map<String, String> optionPairsToPrint = this.populateOptionPairMap(aStoredQuery);
        Multimap annotations = aStoredQuery.getAnnotations();
        Iterable<Namespace> aNamespaces = StoredQueryAdd.getNamespaceIterable(aStoredQuery.getDatabase(), theConn);
        try {
            if (this.mAnnotations.isEmpty()) {
                StoredQueryIO.writeTable(optionPairsToPrint, (Collection)annotations.entries(), aNamespaces, (OutputStream)System.out);
            } else {
                Collection<IRI> aIRIs = this.readOptions(this.mAnnotations);
                Map<IRI, Value> aIRIValueMap = annotations.entries().stream().filter(entry -> aIRIs.contains(entry.getKey())).collect(Collectors.toMap(entry -> (IRI)entry.getKey(), entry -> (Value)entry.getValue()));
                StoredQueryIO.writeTable(optionPairsToPrint, aIRIValueMap.entrySet(), aNamespaces, (OutputStream)System.out);
            }
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, StardogException.class);
            throw new CliException(e);
        }
    }

    protected Collection<IRI> readOptions(Collection<String> annotations) {
        TurtleValueParser aParser = new TurtleValueParser((Iterable)Namespaces.DEFAULT);
        HashSet aIRIs = Sets.newHashSet();
        for (String aAnnotation : annotations) {
            try {
                aIRIs.add((IRI)aParser.parse(aAnnotation));
            }
            catch (Exception e) {
                throw new CliException("Invalid IRI supplied as option key: " + aAnnotation);
            }
        }
        return aIRIs;
    }

    private Map<String, String> populateOptionPairMap(StoredQuery theStoredQuery) {
        LinkedHashMap<String, String> optionPairsToPrint = new LinkedHashMap<String, String>();
        optionPairsToPrint.put("Name", theStoredQuery.getName());
        optionPairsToPrint.put("Query String", theStoredQuery.getQuery());
        optionPairsToPrint.put("Database", theStoredQuery.getDatabase());
        optionPairsToPrint.put("Reasoning", String.valueOf(theStoredQuery.isReasoning()));
        optionPairsToPrint.put("Shared", String.valueOf(theStoredQuery.isShared()));
        optionPairsToPrint.put("Creator", theStoredQuery.getCreator());
        if (theStoredQuery.getSchema() != null) {
            optionPairsToPrint.put("Schema", theStoredQuery.getSchema());
        }
        if (theStoredQuery.getDescription() != null) {
            optionPairsToPrint.put("Description", theStoredQuery.getDescription());
        }
        if (theStoredQuery.isTrigger()) {
            StoredQuery.TriggerStatus triggerStatus;
            DateTimeFormatter dtf = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM);
            optionPairsToPrint.put("Trigger", "Yes");
            optionPairsToPrint.put("Trigger Limit", String.valueOf(theStoredQuery.getTriggerLimit()));
            if (theStoredQuery.getTriggerSchedule() > 0) {
                optionPairsToPrint.put("Trigger Frequency", theStoredQuery.getTriggerSchedule() + "s");
            }
            if (theStoredQuery.getTriggerTimeout() > 0) {
                optionPairsToPrint.put("Trigger Timeout", theStoredQuery.getTriggerTimeout() + "s");
            }
            if ((triggerStatus = theStoredQuery.getTriggerStatus()) != null) {
                optionPairsToPrint.put("Trigger Last Run", this.format(dtf, triggerStatus.lastRunTime));
                if (triggerStatus.lastRunTime > 0L && triggerStatus.errorMessage == null) {
                    long nextRun = triggerStatus.nextRunTime;
                    optionPairsToPrint.put("Trigger Planned Run", this.format(dtf, nextRun));
                }
                optionPairsToPrint.put("Trigger Last Change", this.format(dtf, triggerStatus.lastChangeTime));
                if (triggerStatus.errorMessage != null && !triggerStatus.errorMessage.isEmpty()) {
                    optionPairsToPrint.put("Trigger Status", triggerStatus.errorMessage);
                }
                optionPairsToPrint.put("Trigger Payload Type", theStoredQuery.getTriggerPayloadType().name());
            }
        }
        return optionPairsToPrint;
    }

    private String format(DateTimeFormatter fmt, long millis) {
        if (millis <= 0L) {
            return "Never";
        }
        return fmt.format(Instant.ofEpochMilli(millis).atZone(ZoneId.systemDefault()));
    }

    static class StoredQueryOptionPair {
        private String mKey;
        private String mValue;

        public StoredQueryOptionPair(String theKey, String theValue) {
            this.mKey = theKey;
            this.mValue = theValue;
        }

        public String getKey() {
            return this.mKey;
        }

        public String getValue() {
            return this.mValue;
        }
    }
}

