/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.StoredQueryIO;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.CliUtil;
import com.complexible.stardog.cli.impl.StoredQueryBulkGet;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.stardog.stark.io.CompressedRDFFormat;
import com.stardog.stark.io.FileFormat;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFHandler;
import com.stardog.stark.io.RDFWriter;
import com.stardog.stark.io.RDFWriters;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.FileOutputStream;
import java.io.OutputStream;

@Command(name="export", description="Exports the stored queries in RDF format", discussion="Exports the queries currently stored in the system in RDF format.", examples={"* Export the stored queries:", "    $ stardog-admin stored export", "", "* Export the stored queries to a file:", "    $ stardog-admin stored export export.ttl", ""})
public final class StoredQueryExport
extends StoredQueryBulkGet {
    @Option(name={"-f", "--format"}, description="RDF Format [NTRIPLES, RDF/XML, TURTLE, PRETTY_TURTLE, TRIG, N3, NQUADS, JSONLD] for the exported data.", title="RDF Format")
    public String mFormat;
    @Option(name={"--compression"}, description="Compression format [GZIP, BZ2] for the exported data.", title="Compression")
    public String mCompression;
    @Arguments(required=false, description="The file to write the output to; if not specified, the output is written to STDOUT. ", title={"export file"})
    public String mFile;

    @Inject
    public StoredQueryExport(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        OutputStream aOutput = System.out;
        try {
            boolean aIsFormat;
            RDFFormat aFormat = RDFFormats.TURTLE;
            boolean bl = aIsFormat = !Strings.isNullOrEmpty((String)this.mFormat);
            if (aIsFormat) {
                aFormat = CliUtil.getFormat(this.mFormat);
                if (aFormat == null) {
                    throw new StardogException("Unrecognized output format: " + this.mFormat);
                }
                if (!Strings.isNullOrEmpty((String)this.mCompression)) {
                    try {
                        FileFormat.Compression aCompression = FileFormat.Compression.of((String)this.mCompression.toUpperCase());
                        aFormat = new CompressedRDFFormat(aFormat, aCompression);
                    }
                    catch (IllegalArgumentException e) {
                        throw new StardogException("Unrecognized compression format: " + this.mCompression, (Throwable)e);
                    }
                }
            } else if (this.mFile != null) {
                aFormat = RDFFormats.forFile((String)this.mFile, (RDFFormat)aFormat);
                aOutput = new FileOutputStream(this.mFile);
            }
            RDFWriter aWriter = (RDFWriter)RDFWriters.to((OutputStream)aOutput, (RDFFormat)aFormat).get();
            StoredQueryIO.toRDF(this.filterQueries(theConn.getStoredQueries()), (boolean)false, (RDFHandler)aWriter);
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, StardogException.class);
            throw new CliException(e);
        }
    }
}

