/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StoredQueries;
import com.complexible.stardog.StoredQuery;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import io.airlift.command.Option;
import java.util.Optional;
import java.util.regex.Pattern;

public abstract class StoredQueryBulkGet
extends SecureStardogAdminCommand<Void> {
    @Option(name={"--db", "--database"}, description="Name of the database (or a regular expression) for which the stored queries should be retrieved", title="Database name")
    public String mDb = null;
    @Option(name={"--query"}, description="Name of the query (or a regular expression) to get", title="query name")
    public String mQuery = null;

    @Inject
    protected StoredQueryBulkGet(PasswordReader theReader) {
        super(theReader);
    }

    protected Iterable<StoredQuery> filterQueries(StoredQueries storedQueries) {
        Iterable queries = storedQueries.list(Optional.ofNullable(this.mDb));
        if (this.mQuery != null) {
            Pattern regex = Pattern.compile(this.mQuery);
            queries = Iterables.filter((Iterable)queries, q -> regex.matcher(q.getName()).matches());
        }
        return queries;
    }
}

