/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.base.Durations;
import com.complexible.common.base.Pair;
import com.complexible.common.io.Files2;
import com.complexible.stardog.ImmutableStoredQuery;
import com.complexible.stardog.Schemas;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.StoredQueries;
import com.complexible.stardog.StoredQuery;
import com.complexible.stardog.api.ConnectionConfiguration;
import com.complexible.stardog.api.ConnectionCredentials;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.cli.impl.CliUtil;
import com.complexible.stardog.cli.impl.StoredQuerySet;
import com.complexible.stardog.db.DatabaseOptions;
import com.complexible.stardog.metadata.MetaProperty;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.io.MoreFiles;
import com.google.common.primitives.Ints;
import com.google.inject.Inject;
import com.stardog.stark.Namespace;
import com.stardog.stark.Namespaces;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;

@Command(name="add", description="Adds a new stored query", discussion="Adds a new stored query. Stored queries can be executed directly by using their name. Shared queries can be executed by any user. Private queries can only be executed by their creator or super users. Stored queries can be executed over the database associated with the query. The special value `*` can be used to indicate a query can be executed over any database.", examples={"* Adds a new stored query over all databases:", "    $ stardog-admin stored add listProperties.sparql", "", "* Adds a new shared stored query with a custom name and for database myDb:", "    $ stardog-admin stored add --shared -d myDb -n listProperties query.sparql", "", "* Adds a new stored query overwriting previous query with same name:", "    $ stardog-admin stored add --overwrite -d myDb -n listProperties query.sparql", "", "* Adds a new stored query as a trigger, reporting a result change every 15 seconds.", "    $ stardog-admin stored add --name product_trigger --database mydb --trigger --trigger-schedule 15 --trigger-limit 500 query.sparql"})
public final class StoredQueryAdd
extends SecureStardogAdminCommand<Void> {
    @Option(name={"-d", "--database"}, title="db", description="The database the query will be associated with. By default, '*' will be used which means the query can be executed over any database.")
    public String mDb = "*";
    @Option(name={"-n", "--name"}, title="name", description="Unique name for the stored query. This name is used to retrieve the stored query later. If no name is given but a query file is provided the name of the file without the extension will be used. The first letter must be an alpha character. Subsequent characters may be alphanumeric, underscore, or dash.")
    public String mName;
    @Option(name={"--description"}, title="description", description="A human readable description of the query.")
    public String mDescription;
    @Option(name={"--shared"}, description="Share this query with other users. By default, only the user who stores the query can access it.")
    public boolean mShared = false;
    @Option(name={"--reasoning"}, description="Enable reasoning for this stored query. If this flag is set then the stored query will always be executed with reasoning even if the reasoning is not enabled for the connection explicitly. The stored query will use the default reasoning schema. ")
    public boolean mReasoning = false;
    @Option(name={"--schema"}, description="Specify the reasoning schema that will be used for this query. If this flag is set then the stored query  will always be executed with the specified schema even if the reasoning is not enabled for the connection explicitly or the connection has another schema specified.")
    public String mSchema = Schemas.NULL;
    @Option(name={"-a", "--annotation"}, description="One or more configuration annotations to be saved for a stored query. Each annotation is a 'key=value' pair; multiple annotations are separated by whitespaces, e.g., '-o \"IRIKey1=RDFValue1 IRIKey2=RDFValue2\"'. ", title="annotations", arity=0x7FFFFFFF)
    public List<String> mAnnotations = Lists.newArrayList();
    @Option(name={"--overwrite"}, description="Overwrite an existing stored query with the same name.")
    public boolean mOverwrite = false;
    @Option(name={"--trigger"}, description="Is this a query whose results will be watched.")
    public boolean mTrigger = false;
    @Option(name={"--trigger-limit"}, title="limit", description="Number of query result rows to watch.")
    public int mTriggerLimit = 1000;
    @Option(description="Defines the interval for checking if query results have changed. Required for triggers. An optional time unit can be specified by the suffix 'h' (for hours), 'm' (for minutes), or 's' (for seconds).", name={"--trigger-schedule"}, title="N[h|m|s]")
    public String mTriggerSchedule = null;
    @Option(name={"--trigger-timeout"}, title="N[h|m|s]", description="Timeout used for trigger queries. If the query does not return in this time, the trigger will be disabled. An optional time unit can be specified by the suffix 'h' (for hours), 'm' (for minutes), or 's' (for seconds). ")
    public String mTriggerTimeout = null;
    @Option(name={"--trigger-payload"}, title="payload", description="Defines the payload type for the trigger. Options are: None, Full.")
    public String mTriggerPayload = StoredQuery.TriggerPayloadType.None.name();
    @Arguments(required=true, title={"query"}, description="The SPARQL query string to store. This can either be a file name or a SPARQL query string.")
    public String mQuery;

    @Inject
    public StoredQueryAdd(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        StoredQuery.TriggerPayloadType payloadType;
        Pair<String, String> queryNamePair = this.adjustNameAndQuery(this.mQuery, this.mName);
        ArrayListMultimap aAnnotationMap = ArrayListMultimap.create();
        StoredQuerySet.readAnnotations(this.mAnnotations, StoredQueryAdd.getNamespaceIterable(this.mDb, theConn)).forEach((arg_0, arg_1) -> ((Multimap)aAnnotationMap).put(arg_0, arg_1));
        if (this.mTrigger && this.mTriggerSchedule == null) {
            throw new CliException(StoredQueryAdd.get("stored.trigger.schedule.invalid", new Object[0]));
        }
        if (this.mTriggerSchedule != null) {
            this.mTrigger = true;
        }
        try {
            payloadType = StoredQuery.TriggerPayloadType.valueOf((String)this.mTriggerPayload);
        }
        catch (IllegalArgumentException e) {
            throw new CliException("Invalid trigger payload type: " + this.mTriggerPayload + ". Valid options are: None or Full.");
        }
        Pair<List<String>, String> pathNamePair = this.splitFullPath((String)queryNamePair.second);
        ImmutableStoredQuery aQuery = ImmutableStoredQuery.builder().name((String)pathNamePair.second).path((List)pathNamePair.first).description(this.mDescription).query((String)queryNamePair.first).database(this.mDb).creator(this.getConnCredentialsSubject(theConn)).shared(this.mShared).schema(this.mSchema == null && this.mReasoning ? "default" : this.mSchema).annotations((Multimap)aAnnotationMap).triggerLimit(this.mTrigger ? this.mTriggerLimit : 0).triggerSchedule(this.mTrigger ? this.parseDuration(this.mTriggerSchedule) : 0).triggerTimeout(this.mTriggerTimeout != null ? this.parseDuration(this.mTriggerTimeout) : 0).triggerPayloadType(payloadType).build();
        if (aQuery.isTrigger()) {
            if (this.mTrigger && aQuery.getTriggerSchedule() <= 0) {
                throw new CliException(StoredQueryAdd.get("stored.trigger.schedule.invalid", aQuery.getTriggerSchedule()));
            }
            if (aQuery.getTriggerTimeout() != 0 && aQuery.getTriggerTimeout() > aQuery.getTriggerSchedule()) {
                throw new CliException(StoredQueryAdd.get("stored.trigger.timeout.invalid", aQuery.getTriggerTimeout(), aQuery.getTriggerSchedule()));
            }
        }
        StoredQueries aStoredQueries = theConn.getStoredQueries();
        try {
            if (this.mOverwrite) {
                aStoredQueries.update((StoredQuery)aQuery);
                System.out.println(StoredQueryAdd.get("stored.updated", "query"));
            } else {
                aStoredQueries.add((StoredQuery)aQuery);
                System.out.println(StoredQueryAdd.get("stored.added", "query"));
            }
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().contains("Stored query already exists")) {
                throw new CliException(StoredQueryAdd.get("stored.overwrite", "Query"));
            }
            Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new CliException(e);
        }
    }

    private int parseDuration(String input) {
        Preconditions.checkNotNull((Object)input, (Object)"Duration input must not be null");
        int schedule = Ints.saturatedCast((long)Durations.parse((String)input, (TimeUnit)TimeUnit.SECONDS));
        if (schedule <= 0) {
            throw new CliException(StoredQueryAdd.get("stored.duration.invalid", input));
        }
        return schedule;
    }

    private Pair<List<String>, String> splitFullPath(String theFullPath) {
        List<String> components = List.of(theFullPath.split("/"));
        if (components.isEmpty()) {
            return Pair.create(List.of(), (Object)theFullPath);
        }
        return Pair.create(components.subList(0, components.size() - 1), (Object)components.getLast());
    }

    private Pair<String, String> adjustNameAndQuery(String theQuery, String theName) {
        File aFile = new File(theQuery);
        boolean aFileExists = aFile.exists();
        if (aFileExists) {
            try {
                theQuery = Files2.toString((Path)aFile.toPath(), (Charset)Charsets.UTF_8);
            }
            catch (IOException e) {
                throw new CliException(e);
            }
        }
        theQuery = CliUtil.cleanQuery(theQuery);
        if (theName == null) {
            if (aFileExists) {
                theName = MoreFiles.getNameWithoutExtension((Path)aFile.toPath());
            } else {
                throw new CliException(StoredQueryAdd.get("stored.no.name", new Object[0]));
            }
        }
        return Pair.create((Object)theQuery, (Object)theName);
    }

    private String getConnCredentialsSubject(AdminConnection theConn) {
        String aCreator;
        if (this.mToken != null) {
            aCreator = theConn.whoami();
        } else if (!this.mUseKrb5.booleanValue()) {
            aCreator = this.mCredentials != null ? (String)this.mCredentials.get(ConnectionConfiguration.USERNAME) : this.mUsername;
        } else {
            ConnectionCredentials aCC = ConnectionCredentials.getKrb5Credential();
            aCreator = aCC.getSubject();
        }
        return aCreator;
    }

    static Iterable<Namespace> getNamespaceIterable(String dbName, AdminConnection theConn) {
        Object aNamespaces = Namespaces.DEFAULT;
        if (!dbName.equals("*") && !dbName.isEmpty()) {
            try {
                aNamespaces = (Iterable)theConn.get(dbName, (MetaProperty)DatabaseOptions.NAMESPACES);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return aNamespaces;
    }
}

