/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.StoredFunctions;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import io.airlift.command.OptionType;

@Command(name="remove", description="Removes a stored function", discussion="Removes a new stored function from the system. If there is another stored function that uses the removed function it will NOT be removed. The functions that depend on the removed function will trigger an error during runtime when they are used next time.", examples={"* Removes a stored function:", "    $ stardog-admin function remove permutation"})
public final class StoredFunctionRemove
extends SecureStardogAdminCommand<Void> {
    @Arguments(required=false, description="Name of the stored function to delete.", title={"name"})
    public String mName;
    @Option(name={"-a", "--all"}, type=OptionType.COMMAND, description="Remove all flag. If this flag is set, all stored functions will be removed.", arity=0)
    protected boolean mAll = false;

    @Inject
    public StoredFunctionRemove(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        StoredFunctions aStoredFunctions = theConn.getStoredFunctions();
        if (this.mAll) {
            if (this.mName != null) {
                throw new CliException(StoredFunctionRemove.get("stored.remove.all.error", "function"));
            }
            aStoredFunctions.clear();
            System.out.println(StoredFunctionRemove.get("stored.removed.all", "functions"));
        } else {
            aStoredFunctions.remove(this.mName);
            System.out.println(StoredFunctionRemove.get("stored.removed", "function"));
        }
    }
}

